/*
 * Decompiled with CFR 0.152.
 */
package net.apocalypselabs.symat.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import net.apocalypselabs.symat.Main;
import net.apocalypselabs.symat.Theme;
import net.apocalypselabs.symat.components.TaskMenu;

public class Task
extends JPanel {
    private int percent = 0;
    private JScrollPane jScrollPane1;
    private JButton menuBtn;
    private JProgressBar percentDone;
    private JLabel statusLabel;
    private JTextArea taskDesc;
    private JLabel taskName;

    public Task(boolean complete, String name, String desc) {
        this(complete ? 100 : 0, name, desc);
    }

    public Task(int complete, String name, String desc) {
        this();
        this.percent = complete;
        this.setComplete(this.percent);
        this.taskName.setText(name);
        this.taskDesc.setText(desc);
        this.loadTheme();
    }

    private void loadTheme() {
        this.taskDesc.setBackground(Theme.boxColor());
        this.taskDesc.setForeground(Theme.textColor());
        this.taskName.setForeground(Theme.textColor());
        this.setBackground(Theme.windowColor());
    }

    @Override
    public String toString() {
        return this.taskName.getText();
    }

    public String getDesc() {
        return this.taskDesc.getText();
    }

    public int getComplete() {
        return this.percent;
    }

    public Task() {
        this.initComponents();
    }

    private void setComplete(int i) {
        this.percent = i;
        this.statusLabel.setIcon(new ImageIcon(this.getClass().getResource("/net/apocalypselabs/symat/icons/" + (i == 100 ? "green" : "red") + "light.png")));
        this.statusLabel.setToolTipText(i == 100 ? "Complete" : "Incomplete");
        this.percentDone.setValue(i);
        this.percentDone.setString(i + "%");
    }

    private void initComponents() {
        this.taskName = new JLabel();
        this.menuBtn = new JButton();
        this.statusLabel = new JLabel();
        this.percentDone = new JProgressBar();
        this.jScrollPane1 = new JScrollPane();
        this.taskDesc = new JTextArea();
        this.setBorder(BorderFactory.createEtchedBorder());
        this.taskName.setFont(Main.ubuntuRegular.deriveFont(20.0f));
        this.taskName.setHorizontalAlignment(2);
        this.taskName.setText("Unnamed task");
        this.menuBtn.setText("Menu");
        this.menuBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Task.this.menuBtnActionPerformed(evt);
            }
        });
        this.statusLabel.setIcon(new ImageIcon(this.getClass().getResource("/net/apocalypselabs/symat/icons/redlight.png")));
        this.percentDone.setStringPainted(true);
        this.taskDesc.setEditable(false);
        this.taskDesc.setColumns(1);
        this.taskDesc.setFont(Main.ubuntuRegular.deriveFont(12.0f));
        this.taskDesc.setLineWrap(true);
        this.taskDesc.setRows(1);
        this.taskDesc.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.taskDesc);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.statusLabel, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.taskName, -1, 136, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.menuBtn)).addComponent(this.percentDone, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.menuBtn).addComponent(this.statusLabel, -1, 32, Short.MAX_VALUE).addComponent(this.taskName, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.percentDone, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 72, Short.MAX_VALUE).addGap(0, 0, 0)));
    }

    private void menuBtnActionPerformed(ActionEvent evt) {
        TaskMenu tm = new TaskMenu(this.percent, this.taskName.getText(), this.taskDesc.getText());
        JOptionPane.showInternalMessageDialog(this, tm, "Task Options", -1);
        this.percent = tm.getPercent();
        this.setComplete(this.percent);
        this.taskName.setText(tm.toString());
        this.taskDesc.setText(tm.getDesc());
        if (tm.deleteMe()) {
            this.getParent().remove(this);
        }
    }
}

