/*
 * Decompiled with CFR 0.152.
 */
package net.apocalypselabs.symat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.PromptData;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebView;
import javafx.util.Callback;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import net.apocalypselabs.symat.Main;

public class WebBrowser
extends JInternalFrame {
    private WebView browser;
    private WebEngine webEngine;
    private JFXPanel jfxPanel;
    private Group root;
    private Scene scene;
    public static final int DEFAULT_LOGO = 0;
    public static final int WIKI_LOGO = 1;
    public static final int FORUM_LOGO = 2;
    public static final int PAD_LOGO = 3;
    private JInternalFrame thisFrame;
    private JButton backBtn;
    private JPanel browserBox;
    public JToolBar buttonBar;
    private JButton goBtn;
    private JButton homeBtn;
    private JToolBar navBar;
    private JToolBar.Separator sepBar;
    private JTextField urlBox;

    public WebBrowser() {
        this.initComponents();
        this.thisFrame = this;
        this.jfxPanel = new JFXPanel();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebBrowser.this.browser = new WebView();
                WebBrowser.this.browser.setPrefSize((double)WebBrowser.this.getWidth(), (double)WebBrowser.this.getHeight());
                WebBrowser.this.root = new Group();
                WebBrowser.this.scene = new Scene((Parent)WebBrowser.this.root);
                ObservableList children = WebBrowser.this.root.getChildren();
                children.add((Object)WebBrowser.this.browser);
                WebBrowser.this.jfxPanel.setScene(WebBrowser.this.scene);
                WebBrowser.this.webEngine = WebBrowser.this.browser.getEngine();
                WebBrowser.this.webEngine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

                    public void changed(ObservableValue ov, Worker.State oldState, Worker.State newState) {
                        if (newState == Worker.State.RUNNING) {
                            WebBrowser.this.urlBox.setText("Loading...");
                        } else if (newState != Worker.State.SCHEDULED && newState != Worker.State.READY) {
                            WebBrowser.this.urlBox.setText(WebBrowser.this.webEngine.getLocation());
                        }
                    }
                });
                WebBrowser.this.webEngine.setOnAlert((EventHandler)new EventHandler<WebEvent<String>>(){

                    public void handle(WebEvent<String> t) {
                        JOptionPane.showMessageDialog(WebBrowser.this.thisFrame, t.getData(), "Message from webpage", 1);
                    }
                });
                WebBrowser.this.webEngine.setPromptHandler((Callback)new Callback<PromptData, String>(){

                    public String call(PromptData p) {
                        return JOptionPane.showInputDialog(WebBrowser.this.thisFrame, p.getMessage(), "Question from webpage", 3);
                    }
                });
                WebBrowser.this.webEngine.setConfirmHandler((Callback)new Callback<String, Boolean>(){

                    public Boolean call(String p) {
                        return JOptionPane.showConfirmDialog(WebBrowser.this.thisFrame, p, "Question from webpage", 2) == 0;
                    }
                });
                WebBrowser.this.webEngine.setUserAgent("Mozilla/5.0 SyMAT/2.1");
                WebBrowser.this.webEngine.loadContent(WebBrowser.this.homepage());
            }
        });
        this.browserBox.add((Component)this.jfxPanel, "Center");
    }

    public WebBrowser(String title) {
        this();
        this.setTitle(title);
        this.loadURL("http://wiki.symatapp.com/");
    }

    public WebBrowser(String title, String url) {
        this();
        this.setTitle(title);
        this.loadURL(url);
    }

    public WebBrowser(String title, String url, int icon) {
        this(title, url);
        switch (icon) {
            case 1: {
                this.homeBtn.setVisible(false);
                this.sepBar.setVisible(false);
                this.setFrameIcon(new ImageIcon(this.getClass().getResource("/net/apocalypselabs/symat/icons/wiki.png")));
                break;
            }
            case 2: {
                this.homeBtn.setVisible(false);
                this.sepBar.setVisible(false);
                this.setFrameIcon(new ImageIcon(this.getClass().getResource("/net/apocalypselabs/symat/icons/forum.png")));
                break;
            }
            case 3: {
                this.navBar.setVisible(false);
                this.goBtn.setEnabled(false);
                this.backBtn.setEnabled(false);
                this.homeBtn.setVisible(false);
                this.sepBar.setVisible(false);
                this.setFrameIcon(new ImageIcon(this.getClass().getResource("/net/apocalypselabs/symat/icons/editor.png")));
                break;
            }
            default: {
                this.setFrameIcon(new ImageIcon(this.getClass().getResource("/net/apocalypselabs/symat/icons/browser.png")));
            }
        }
    }

    public WebBrowser(String url, boolean isurl) {
        this();
        this.loadURL(url);
    }

    public void showNavbar(boolean yesno) {
        this.navBar.setVisible(yesno);
        this.goBtn.setEnabled(yesno);
        this.backBtn.setEnabled(yesno);
    }

    public void loadURL(final String url) {
        if (url.startsWith("about:")) {
            final String action = url.replace("about:", "");
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    switch (action) {
                        case "home": {
                            WebBrowser.this.webEngine.loadContent(WebBrowser.this.homepage());
                            break;
                        }
                        case "blank": {
                            WebBrowser.this.webEngine.loadContent("");
                            break;
                        }
                        case "new": {
                            Main.loadFrame(new WebBrowser());
                            break;
                        }
                        default: {
                            WebBrowser.this.webEngine.loadContent(WebBrowser.this.errorpage("Invalid URL", "That isn't a valid address."));
                        }
                    }
                    WebBrowser.this.resizeAll();
                }
            });
            this.urlBox.setText(url);
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    WebBrowser.this.webEngine.load(url);
                    WebBrowser.this.resizeAll();
                }
            });
            this.urlBox.setText(url);
        }
    }

    public String homepage() {
        try {
            String line;
            String text = "";
            BufferedReader reader = new BufferedReader(new InputStreamReader(WebBrowser.class.getResourceAsStream("resources/homepage.html")));
            while ((line = reader.readLine()) != null) {
                text = text + line;
            }
            return text;
        }
        catch (IOException ex) {
            return this.errorpage("Error: " + ex.getMessage(), ex.toString());
        }
    }

    public String errorpage(String error, String details) {
        try {
            String line;
            String text = "";
            BufferedReader reader = new BufferedReader(new InputStreamReader(WebBrowser.class.getResourceAsStream("resources/errorpage.html")));
            while ((line = reader.readLine()) != null) {
                text = text + line;
            }
            text = text.replaceAll("<<<ERROR>>>", error);
            text = text.replaceAll("<<<DETAILS>>>", details);
            return text;
        }
        catch (IOException ex) {
            return "Oh, no!  Something bad happened:<br />" + error + "<br />Also, an error occured " + "while displaying the error page: " + ex.getMessage();
        }
    }

    public void open() {
        Main.loadFrame(this, true);
    }

    public void loadString(final String content) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebBrowser.this.webEngine.loadContent(content);
                WebBrowser.this.resizeAll();
            }
        });
        this.urlBox.setText("");
    }

    private void initComponents() {
        this.navBar = new JToolBar();
        this.backBtn = new JButton();
        this.urlBox = new JTextField();
        this.buttonBar = new JToolBar();
        this.goBtn = new JButton();
        this.sepBar = new JToolBar.Separator();
        this.homeBtn = new JButton();
        this.browserBox = new JPanel();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Browser");
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/net/apocalypselabs/symat/icons/browser.png")));
        this.setMinimumSize(new Dimension(300, 300));
        this.setPreferredSize(new Dimension(480, 400));
        this.addInternalFrameListener(new InternalFrameListener(){

            @Override
            public void internalFrameActivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent evt) {
                WebBrowser.this.formInternalFrameOpened(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                WebBrowser.this.formComponentResized(evt);
            }

            @Override
            public void componentShown(ComponentEvent evt) {
                WebBrowser.this.formComponentShown(evt);
            }
        });
        this.navBar.setFloatable(false);
        this.navBar.setRollover(true);
        this.navBar.setLayout(new BorderLayout());
        this.backBtn.setFont(Main.ubuntuRegular.deriveFont(16.0f));
        this.backBtn.setIcon(new ImageIcon(this.getClass().getResource("/net/apocalypselabs/symat/icons/arrow-left.png")));
        this.backBtn.setToolTipText("Go back a page");
        this.backBtn.setFocusable(false);
        this.backBtn.setHorizontalTextPosition(0);
        this.backBtn.setMaximumSize(new Dimension(50, 50));
        this.backBtn.setMinimumSize(new Dimension(30, 21));
        this.backBtn.setPreferredSize(new Dimension(30, 21));
        this.backBtn.setVerticalTextPosition(3);
        this.navBar.add((Component)this.backBtn, "West");
        this.backBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebBrowser.this.backBtnActionPerformed(evt);
            }
        });
        this.urlBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                WebBrowser.this.urlBoxKeyTyped(evt);
            }
        });
        this.navBar.add((Component)this.urlBox, "Center");
        this.buttonBar.setFloatable(false);
        this.buttonBar.setRollover(true);
        this.buttonBar.setBorderPainted(false);
        this.navBar.add((Component)this.buttonBar, "East");
        this.goBtn.setIcon(new ImageIcon(this.getClass().getResource("/net/apocalypselabs/symat/icons/goarrow.png")));
        this.goBtn.setToolTipText("Navigate");
        this.goBtn.setHorizontalTextPosition(0);
        this.goBtn.setMaximumSize(new Dimension(50, 50));
        this.goBtn.setMinimumSize(new Dimension(30, 21));
        this.goBtn.setPreferredSize(new Dimension(30, 30));
        this.goBtn.setVerticalTextPosition(3);
        this.buttonBar.add(this.goBtn);
        this.goBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebBrowser.this.goBtnActionPerformed(evt);
            }
        });
        this.buttonBar.add(this.sepBar);
        this.homeBtn.setIcon(new ImageIcon(this.getClass().getResource("/net/apocalypselabs/symat/icons/home.png")));
        this.homeBtn.setToolTipText("Go to homepage");
        this.homeBtn.setFocusable(false);
        this.homeBtn.setHorizontalTextPosition(0);
        this.homeBtn.setMaximumSize(new Dimension(50, 50));
        this.homeBtn.setVerticalTextPosition(3);
        this.homeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebBrowser.this.homeBtnActionPerformed(evt);
            }
        });
        this.buttonBar.add(this.homeBtn);
        this.getContentPane().add((Component)this.navBar, "First");
        this.browserBox.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.browserBox, "Center");
        this.pack();
    }

    private void formInternalFrameOpened(InternalFrameEvent evt) {
    }

    private void formComponentResized(ComponentEvent evt) {
        this.resizeAll();
    }

    private void formComponentShown(ComponentEvent evt) {
        this.resizeAll();
    }

    private void urlBoxKeyTyped(KeyEvent evt) {
        if (evt.getKeyChar() == '\n') {
            this.goBtn.doClick();
        }
    }

    private void goBtnActionPerformed(ActionEvent evt) {
        if (this.urlBox.getText().equals("about:home")) {
            this.loadString(this.homepage());
        } else {
            if (!this.urlBox.getText().startsWith("http") && !this.urlBox.getText().startsWith("about:")) {
                this.urlBox.setText("http://" + this.urlBox.getText());
            }
            this.loadURL(this.urlBox.getText());
        }
    }

    private void backBtnActionPerformed(ActionEvent evt) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    WebBrowser.this.browser.getEngine().getHistory().go(-1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void homeBtnActionPerformed(ActionEvent evt) {
        this.loadURL("about:home");
    }

    private void resizeAll() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebBrowser.this.jfxPanel.setSize(WebBrowser.this.browserBox.getWidth(), WebBrowser.this.browserBox.getHeight());
                WebBrowser.this.browser.setPrefSize((double)WebBrowser.this.browserBox.getWidth(), (double)WebBrowser.this.browserBox.getHeight());
                WebBrowser.this.browser.resize((double)WebBrowser.this.browserBox.getWidth(), (double)WebBrowser.this.browserBox.getHeight());
            }
        });
    }

    public void addButton(JComponent btn) {
        this.buttonBar.add(btn);
    }

    public void addButton(JButton btn, ActionListener action) {
        this.buttonBar.add(btn);
        btn.addActionListener(action);
    }
}

