/*
 * Decompiled with CFR 0.152.
 */
package net.apocalypselabs.symat;

import java.awt.Color;
import net.apocalypselabs.symat.PrefStorage;

public class Theme {
    private static final Color WHITE = Color.WHITE;
    private static final Color BLACK = Color.BLACK;
    private static final Color DBACK = new Color(41, 49, 52);
    private static final Color LBACK = new Color(240, 240, 240);
    private static final Color DGRAY = Color.DARK_GRAY;
    private static final Color LGRAY = Color.LIGHT_GRAY;
    private static final Color NTPAD = new Color(255, 255, 204);
    public static final int THEME_LIGHT = 0;
    public static final int THEME_DARK = 1;
    public static final int THEME_NEO = 1337;
    public static int currentTheme = PrefStorage.getSetting("theme").equals("dark") ? 1 : (PrefStorage.getSetting("theme").equals("neo") ? 1337 : 0);

    public static void setTheme(int theme) {
        switch (theme) {
            case 1: {
                PrefStorage.saveSetting("theme", "dark");
                break;
            }
            case 1337: {
                PrefStorage.saveSetting("theme", "neo");
                break;
            }
            default: {
                PrefStorage.saveSetting("theme", "light");
            }
        }
        currentTheme = theme;
    }

    public static void setTheme(String theme) {
        switch (theme) {
            case "dark": {
                Theme.setTheme(1);
                break;
            }
            case "neo": {
                Theme.setTheme(1337);
                break;
            }
            default: {
                Theme.setTheme(0);
            }
        }
    }

    public static String getTheme() {
        switch (currentTheme) {
            case 1: {
                return "dark";
            }
            case 1337: {
                return "neo";
            }
        }
        return "light";
    }

    public static Color textColor() {
        if (currentTheme == 1337) {
            return Color.GREEN;
        }
        return currentTheme == 0 ? BLACK : WHITE;
    }

    public static Color boxColor() {
        return currentTheme == 0 ? WHITE : DBACK;
    }

    public static Color notepadColor() {
        return currentTheme == 0 ? NTPAD : DBACK;
    }

    public static Color windowColor() {
        return currentTheme == 0 ? LGRAY : DGRAY;
    }

    public static Color tabColor() {
        return currentTheme == 0 ? LBACK : DBACK;
    }

    public static String editorTheme() {
        if (currentTheme == 1337) {
            return "neo";
        }
        return currentTheme == 0 ? "default" : "dark";
    }
}

