/*
 * Decompiled with CFR 0.152.
 */
package net.apocalypselabs.symat;

import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.embed.swing.JFXPanel;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Group;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.WritableImage;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.apocalypselabs.symat.Debug;
import net.apocalypselabs.symat.FileUtils;
import net.apocalypselabs.symat.Main;
import net.apocalypselabs.symat.PrefStorage;
import net.apocalypselabs.symat.components.Task;
import net.apocalypselabs.symat.components.TaskList;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.SimpleHtmlSerializer;
import org.htmlcleaner.TagNode;

public class TasksExport
extends JInternalFrame {
    private String html;
    private TaskList tl;
    private WebView browser;
    private WebEngine webEngine;
    private JFXPanel jfxPanel;
    private Group root;
    private Scene scene;
    private JTextField authBox;
    private JTextField dateBox;
    private JButton exHtml;
    private JTextArea headerBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane2;
    private JButton previewBtn;
    private JTextField titleBox;
    private JPanel webPanel;

    public TasksExport(TaskList t) {
        this.initComponents();
        this.jfxPanel = new JFXPanel();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                TasksExport.this.browser = new WebView();
                TasksExport.this.browser.setPrefSize((double)TasksExport.this.getWidth(), (double)TasksExport.this.getHeight());
                TasksExport.this.root = new Group();
                TasksExport.this.scene = new Scene((Parent)TasksExport.this.root);
                ObservableList children = TasksExport.this.root.getChildren();
                children.add((Object)TasksExport.this.browser);
                TasksExport.this.jfxPanel.setScene(TasksExport.this.scene);
                TasksExport.this.webEngine = TasksExport.this.browser.getEngine();
                TasksExport.this.webEngine.setUserAgent("SyMAT 2.1");
                TasksExport.this.webEngine.loadContent("<html><head><title></title></head><body><h3 style=\"font-family: sans-serif; text-align: center;\">Loading...</h3></body></html>");
                TasksExport.this.webPanel.add((Component)TasksExport.this.jfxPanel, "Center");
            }
        });
        this.tl = t;
        this.titleBox.setText(t.getTitle());
        this.html = this.genHtml(t);
        this.loadString(this.html);
    }

    private void resizeAll() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                TasksExport.this.jfxPanel.setSize(TasksExport.this.webPanel.getWidth(), TasksExport.this.webPanel.getHeight());
                TasksExport.this.browser.setPrefSize((double)TasksExport.this.webPanel.getWidth(), (double)TasksExport.this.webPanel.getHeight());
                TasksExport.this.browser.resize((double)TasksExport.this.webPanel.getWidth(), (double)TasksExport.this.webPanel.getHeight());
            }
        });
    }

    public void loadString(final String content) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                TasksExport.this.webEngine.loadContent(content);
                TasksExport.this.resizeAll();
            }
        });
    }

    private String genHtml(TaskList tt) {
        String css = "";
        BufferedReader reader = new BufferedReader(new InputStreamReader(TasksExport.class.getResourceAsStream("tasks.css")));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                css = css + line;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(TasksExport.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.html = "<!DOCTYPE html><html><head><meta charset=\"utf-8\"><title>" + this.titleBox.getText() + "</title>" + "<style type=\"text/css\"><!--" + css + "--></style>" + "</head>" + "<body>" + "<h1>" + this.titleBox.getText() + "</h1>";
        if (!this.authBox.getText().equals("")) {
            this.html = this.html + "<h2>Author: " + this.authBox.getText() + "</h2>";
        }
        if (!this.dateBox.getText().equals("")) {
            this.html = this.html + "<h3>Date: " + this.dateBox.getText() + "</h3>";
        }
        if (!this.headerBox.getText().equals("")) {
            this.html = this.html + "<p class=\"header\">" + this.headerBox.getText() + "</p>";
        }
        for (Task t : tt.getTasks()) {
            this.html = this.html + "<div class=\"task\"><h4 class=\"taskheading\">" + t.toString() + "</h4>" + this.percentBar(t.getComplete()) + "<p>" + t.getDesc() + "</p>" + "</div>";
        }
        this.html = this.html + "</body></html>";
        this.html = this.html.replace("\t", "<span class=\"tab\">&nbsp;&nbsp;&nbsp;&nbsp;</span>");
        this.html = this.html.replace("\n", "<br>");
        HtmlCleaner cleaner = new HtmlCleaner();
        CleanerProperties props = cleaner.getProperties();
        TagNode node = cleaner.clean(this.html);
        this.html = new SimpleHtmlSerializer(props).getAsString(node);
        this.html = this.html.replace("&apos;", "'");
        this.html = this.html.replace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "");
        Debug.println(this.html);
        return this.html;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.titleBox = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.authBox = new JTextField();
        this.dateBox = new JTextField();
        this.jLabel3 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.headerBox = new JTextArea();
        this.jLabel4 = new JLabel();
        this.previewBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.exHtml = new JButton();
        this.webPanel = new JPanel();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Export Task List");
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/net/apocalypselabs/symat/icons/export.png")));
        this.setMinimumSize(new Dimension(599, 300));
        this.setPreferredSize(new Dimension(599, 418));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                TasksExport.this.formComponentResized(evt);
            }
        });
        this.titleBox.setText("Untitled");
        this.jLabel1.setText("Title:");
        this.jLabel2.setText("Author:");
        this.authBox.setText(PrefStorage.getSetting("author", ""));
        this.jLabel3.setText("Date:");
        this.headerBox.setColumns(20);
        this.headerBox.setLineWrap(true);
        this.headerBox.setRows(2);
        this.headerBox.setTabSize(4);
        this.headerBox.setWrapStyleWord(true);
        this.jScrollPane2.setViewportView(this.headerBox);
        this.jLabel4.setText("Header:");
        this.previewBtn.setText("Update Preview");
        this.previewBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TasksExport.this.previewBtnActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Export to:"));
        this.exHtml.setText("HTML");
        this.exHtml.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TasksExport.this.exHtmlActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.exHtml, -1, 80, Short.MAX_VALUE).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(19, 19, 19).addComponent(this.exHtml).addContainerGap(21, Short.MAX_VALUE)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.titleBox, -1, 154, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dateBox).addComponent(this.authBox)))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.previewBtn)).addComponent(this.jScrollPane2, -1, 239, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -2, -1, -2).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(5, 5, 5).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -2, -1, -2).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.titleBox, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.jLabel4).addComponent(this.previewBtn)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.authBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dateBox, -2, -1, -2).addComponent(this.jLabel3))).addComponent(this.jScrollPane2, -2, 55, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        this.webPanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.webPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.webPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addGap(10, 10, 10)));
        this.pack();
    }

    private void previewBtnActionPerformed(ActionEvent evt) {
        this.html = this.genHtml(this.tl);
        this.loadString(this.html);
    }

    private void exHtmlActionPerformed(ActionEvent evt) {
        this.html = this.genHtml(this.tl);
        this.doSave("html");
    }

    private void formComponentResized(ComponentEvent evt) {
        this.resizeAll();
    }

    private void doSave(String format) {
        FileNameExtensionFilter filter;
        JFileChooser fc = new JFileChooser();
        switch (format) {
            case "pdf": {
                filter = new FileNameExtensionFilter("Portable Document Format (PDF)", "pdf");
                break;
            }
            default: {
                filter = new FileNameExtensionFilter("Web Document (HTML)", "html");
            }
        }
        fc.setFileFilter(filter);
        fc.addChoosableFileFilter(filter);
        int r = fc.showSaveDialog(this);
        if (r == 0) {
            String file = FileUtils.getFileWithExtension(fc).getAbsolutePath();
            switch (format) {
                case "html": {
                    this.saveFile(this.html, file);
                    break;
                }
                case "pdf": {
                    this.savePdfFile(this.html, file);
                }
            }
        }
    }

    private String percentBar(int p) {
        int by5 = 5 * Math.round(p / 5);
        String result = "<p>" + by5 + "% <span class=\"progress progress-" + by5 + "\"" + "style=\"width: " + by5 + "%\"></span></p>";
        return result;
    }

    private void savePdfFile(final String html, final String path) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    String k = html;
                    FileOutputStream file = new FileOutputStream(new File(path));
                    Document document = new Document();
                    PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)file);
                    document.open();
                    PdfContentByte pdfCB = new PdfContentByte(writer);
                    WritableImage image = TasksExport.this.browser.snapshot(null, null);
                    BufferedImage buffered = SwingFXUtils.fromFXImage((javafx.scene.image.Image)image, null);
                    com.itextpdf.text.Image img = com.itextpdf.text.Image.getInstance((PdfContentByte)pdfCB, (Image)buffered, (float)1.0f);
                    document.open();
                    document.add((Element)img);
                    document.close();
                    TasksExport.this.savedMsg();
                }
                catch (Exception ex) {
                    Debug.stacktrace(ex);
                    EventQueue.invokeLater(() -> JOptionPane.showInternalMessageDialog(Main.mainPane, "Error saving: " + ex.getMessage()));
                }
            }
        });
    }

    private void saveFile(String content, String path) {
        try {
            PrintStream out = new PrintStream(new FileOutputStream(path));
            out.print(content);
            this.savedMsg();
        }
        catch (Exception ex) {
            JOptionPane.showInternalMessageDialog(this, "Error saving: " + ex.getMessage());
        }
    }

    private void savedMsg() {
        JOptionPane.showInternalMessageDialog(this, "Export complete!");
    }
}

