/*
 * Decompiled with CFR 0.152.
 */
package net.apocalypselabs.symat;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.apocalypselabs.symat.Debug;
import net.apocalypselabs.symat.FileUtils;
import net.apocalypselabs.symat.Main;
import net.apocalypselabs.symat.TasksExport;
import net.apocalypselabs.symat.components.Task;
import net.apocalypselabs.symat.components.TaskList;

public class Tasks
extends JInternalFrame {
    private String tltitle = "Untitled";
    private final JFileChooser fc = new JFileChooser();
    private File ondisk = null;
    private JMenuItem appendBtn;
    private JMenuItem exportBtn;
    private JMenuItem insertItemBtn;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenuBar jMenuBar1;
    private JPanel listPanel;
    private JMenuItem openBtn;
    private JMenuItem saveAsBtn;
    private JMenuItem saveBtn;
    private JMenuItem setTitleBtn;
    private JScrollPane taskList;

    public Tasks() {
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Task List (.sytt)", "sytt");
        this.fc.setFileFilter(filter);
        this.initComponents();
    }

    public Tasks(File f) {
        this();
        try {
            this.openTaskFile(f);
        }
        catch (Exception ex) {
            JOptionPane.showInternalMessageDialog(Main.mainPane, "Cannot open task list: " + ex.getMessage(), "Error", 0);
            Debug.stacktrace(ex);
        }
    }

    private void openTaskFile(File f) throws IOException, ClassNotFoundException {
        Task[] list;
        FileInputStream fin = new FileInputStream(f);
        ObjectInputStream ois = new ObjectInputStream(fin);
        TaskList tl = (TaskList)ois.readObject();
        ois.close();
        for (Task t : list = tl.getTasks()) {
            this.listPanel.add(t);
        }
        this.setTitle(tl.getTitle());
        this.tltitle = tl.getTitle();
        this.ondisk = f;
        this.redraw();
    }

    private void saveTasks(File f) throws FileNotFoundException, IOException {
        TaskList tl = new TaskList();
        for (Component c : this.listPanel.getComponents()) {
            tl.addTask((Task)c);
        }
        tl.setTitle(this.tltitle);
        FileOutputStream fout = new FileOutputStream(f);
        try (ObjectOutputStream oos = new ObjectOutputStream(fout);){
            oos.writeObject(tl);
            oos.close();
            this.ondisk = f;
        }
    }

    private void initComponents() {
        this.taskList = new JScrollPane();
        this.listPanel = new JPanel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.openBtn = new JMenuItem();
        this.appendBtn = new JMenuItem();
        this.saveBtn = new JMenuItem();
        this.saveAsBtn = new JMenuItem();
        this.exportBtn = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.insertItemBtn = new JMenuItem();
        this.setTitleBtn = new JMenuItem();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Tasks");
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/net/apocalypselabs/symat/icons/tasks.png")));
        this.listPanel.setLayout(new BoxLayout(this.listPanel, 1));
        this.taskList.setViewportView(this.listPanel);
        this.jMenu1.setText("File");
        this.openBtn.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openBtn.setText("Open...");
        this.openBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Tasks.this.openBtnActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.openBtn);
        this.appendBtn.setAccelerator(KeyStroke.getKeyStroke(79, 3));
        this.appendBtn.setText("Append...");
        this.appendBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Tasks.this.appendBtnActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.appendBtn);
        this.saveBtn.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveBtn.setText("Save...");
        this.saveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Tasks.this.saveBtnActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.saveBtn);
        this.saveAsBtn.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        this.saveAsBtn.setText("Save As...");
        this.saveAsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Tasks.this.saveAsBtnActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.saveAsBtn);
        this.exportBtn.setText("Export...");
        this.exportBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Tasks.this.exportBtnActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.exportBtn);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Edit");
        this.insertItemBtn.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        this.insertItemBtn.setText("Insert item");
        this.insertItemBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Tasks.this.insertItemBtnActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.insertItemBtn);
        this.setTitleBtn.setText("List title...");
        this.setTitleBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Tasks.this.setTitleBtnActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.setTitleBtn);
        this.jMenuBar1.add(this.jMenu2);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.taskList, GroupLayout.Alignment.TRAILING, -1, 394, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.taskList, GroupLayout.Alignment.TRAILING, -1, 257, Short.MAX_VALUE));
        this.pack();
    }

    private void insertItemBtnActionPerformed(ActionEvent evt) {
        Task t = new Task(0, "Untitled Task", "No description");
        this.listPanel.add(t);
        t.setVisible(true);
        this.redraw();
    }

    private void openBtnActionPerformed(ActionEvent evt) {
        int result = this.fc.showOpenDialog(this);
        if (result == 0) {
            this.listPanel.removeAll();
            try {
                this.openTaskFile(this.fc.getSelectedFile());
            }
            catch (IOException ex) {
                JOptionPane.showInternalMessageDialog(Main.mainPane, "Cannot open task list: " + ex.getMessage(), "Error", 0);
                Debug.stacktrace(ex);
            }
            catch (ClassNotFoundException ex) {
                JOptionPane.showInternalMessageDialog(Main.mainPane, "Cannot open task list: " + ex.getMessage(), "Error", 0);
                Debug.stacktrace(ex);
            }
        }
    }

    private void setTitleBtnActionPerformed(ActionEvent evt) {
        String res = JOptionPane.showInternalInputDialog(this, "Task list title:", "Change Title", 3);
        if (res == null) {
            return;
        }
        if (res.equals("")) {
            return;
        }
        this.setTitle(res);
        this.tltitle = res;
    }

    private void saveBtnActionPerformed(ActionEvent evt) {
        int result;
        if (this.ondisk == null) {
            result = this.fc.showSaveDialog(this);
        } else {
            this.fc.setSelectedFile(this.ondisk);
            result = 0;
        }
        if (result == 0) {
            try {
                this.saveTasks(FileUtils.getFileWithExtension(this.fc));
            }
            catch (IOException ex) {
                JOptionPane.showInternalMessageDialog(Main.mainPane, "Cannot save task list: " + ex.getMessage(), "Error", 0);
                Debug.stacktrace(ex);
            }
        }
    }

    private void saveAsBtnActionPerformed(ActionEvent evt) {
        this.ondisk = null;
        this.saveBtn.doClick();
    }

    private void appendBtnActionPerformed(ActionEvent evt) {
        int result = this.fc.showDialog(this, "Merge List");
        if (result == 0) {
            try {
                this.openTaskFile(this.fc.getSelectedFile());
            }
            catch (IOException ex) {
                JOptionPane.showInternalMessageDialog(Main.mainPane, "Cannot open task list: " + ex.getMessage(), "Error", 0);
                Debug.stacktrace(ex);
            }
            catch (ClassNotFoundException ex) {
                JOptionPane.showInternalMessageDialog(Main.mainPane, "Cannot open task list: " + ex.getMessage(), "Error", 0);
                Debug.stacktrace(ex);
            }
        }
    }

    private void exportBtnActionPerformed(ActionEvent evt) {
        TaskList tl = new TaskList();
        tl.setTitle(this.tltitle);
        for (Component c : this.listPanel.getComponents()) {
            tl.addTask((Task)c);
        }
        Main.loadFrame(new TasksExport(tl));
    }

    private void redraw() {
        this.setSize(this.getWidth() + 1, this.getHeight());
        this.setSize(this.getWidth() - 1, this.getHeight());
    }
}

