/*
 * Decompiled with CFR 0.152.
 */
package net.apocalypselabs.symat;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Calendar;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import net.apocalypselabs.symat.CodeRunner;
import net.apocalypselabs.symat.Debug;
import net.apocalypselabs.symat.Editor;
import net.apocalypselabs.symat.Main;
import net.apocalypselabs.symat.PrefStorage;

public class SplashScreen
extends JFrame {
    private JLabel dispLabel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLayeredPane jLayeredPane1;

    public SplashScreen() {
        this.initComponents();
        this.setBackground(new Color(255, 255, 255, 0));
        this.setIconImages(Main.symatlogo);
        this.setLocationRelativeTo(null);
    }

    private void initComponents() {
        this.jLayeredPane1 = new JLayeredPane();
        this.dispLabel = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("SyMAT");
        this.setCursor(new Cursor(0));
        this.setMinimumSize(new Dimension(500, 400));
        this.setUndecorated(true);
        this.setResizable(false);
        this.setType(Window.Type.POPUP);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                SplashScreen.this.formComponentShown(evt);
            }
        });
        this.jLayeredPane1.setBackground(new Color(255, 255, 255));
        this.dispLabel.setFont(Main.ubuntuRegular.deriveFont(14.0f));
        this.dispLabel.setHorizontalAlignment(0);
        this.dispLabel.setText("Loading...");
        this.dispLabel.setHorizontalTextPosition(2);
        this.dispLabel.setMaximumSize(new Dimension(400, 320));
        this.jLayeredPane1.add(this.dispLabel);
        this.dispLabel.setBounds(100, 200, 220, 70);
        this.jLabel1.setFont(Main.ubuntuRegular.deriveFont(24.0f));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("<html><span style=\"color: #555555;\">2.1</span>");
        this.jLayeredPane1.add(this.jLabel1);
        this.jLabel1.setBounds(290, 140, 140, 50);
        this.jLayeredPane1.setLayer(this.jLabel1, JLayeredPane.POPUP_LAYER);
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/net/apocalypselabs/symat/images/splash.animated.gif")));
        this.jLabel2.setVerticalAlignment(1);
        this.jLayeredPane1.add(this.jLabel2);
        this.jLabel2.setBounds(0, 0, 427, 320);
        this.jLabel3.setFont(Main.ubuntuRegular.deriveFont(12.0f));
        this.jLabel3.setHorizontalAlignment(2);
        this.jLabel3.setText("Netsyms Technologies");
        this.jLayeredPane1.add(this.jLabel3);
        this.jLabel3.setBounds(10, 290, 250, 30);
        this.jLayeredPane1.setLayer(this.jLabel3, JLayeredPane.POPUP_LAYER);
        this.jLabel4.setFont(Main.ubuntuRegular.deriveFont(12.0f));
        this.jLabel4.setHorizontalAlignment(11);
        this.jLabel4.setText("symatapp.com");
        this.jLabel4.setMaximumSize(new Dimension(118, 14));
        this.jLabel4.setMinimumSize(new Dimension(118, 14));
        this.jLabel4.setPreferredSize(new Dimension(118, 14));
        this.jLayeredPane1.add(this.jLabel4);
        this.jLabel4.setBounds(310, 290, 110, 30);
        this.jLayeredPane1.setLayer(this.jLabel4, JLayeredPane.POPUP_LAYER);
        this.getContentPane().add((Component)this.jLayeredPane1, "Center");
        this.pack();
    }

    private void formComponentShown(ComponentEvent evt) {
        new Loader().start();
    }

    private class Loader
    extends Thread {
        private Loader() {
        }

        @Override
        public void run() {
            Object object;
            this.setProgress("Starting up...");
            if (PrefStorage.getSetting("quickstart").equals("yes")) {
                Main.skipPython = true;
                Main.skipEditor = true;
            }
            if (!Main.skipPython) {
                System.out.println("Warming up Python engine, to skip run with argument 'skippython'");
                this.setProgress("Initializing code engine...");
                try {
                    object = new CodeRunner(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!Main.skipEditor) {
                System.out.println("Preparing editor, to skip run with argument 'skipeditor'");
                this.setProgress("Preparing editor...");
                object = new Editor();
            }
            this.setProgress("Loading toolkits...");
            try {
                File[] files;
                String fsep = System.getProperty("file.separator");
                File dir = new File(System.getProperty("user.home") + fsep + ".symat" + fsep + "toolkits");
                dir.mkdirs();
                for (File f : files = dir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".jar");
                    }
                })) {
                    this.addSoftwareLibrary(f);
                }
            }
            catch (Exception ex) {
                Debug.stacktrace(ex);
            }
            this.setProgress("Checking license...");
            this.checkLicense();
            if (!PrefStorage.getSetting("skipupdates").equals("yes")) {
                this.setProgress("Checking for updates...");
                this.checkUpdates();
            }
            this.setProgress("Loading main interface...");
            new Main();
            this.setProgress("Done!");
            SplashScreen.this.dispose();
        }

        private void addSoftwareLibrary(File file) throws Exception {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)ClassLoader.getSystemClassLoader(), file.toURI().toURL());
            Debug.println("Loaded toolkit " + file.getName());
        }

        private void checkLicense() {
            if (PrefStorage.getSetting("license").equals("") || PrefStorage.getSetting("licensetype").equals("demo")) {
                if (PrefStorage.getSetting("licensetype").equals("demo")) {
                    Calendar c = Calendar.getInstance();
                    c.setTime(new Date());
                    try {
                        long expire = Long.parseLong(PrefStorage.getSetting("license"));
                        if (expire > c.getTimeInMillis()) {
                            Main.licValid = true;
                        }
                    }
                    catch (NumberFormatException expire) {}
                }
            } else {
                try {
                    String line;
                    Debug.println("Checking license...");
                    URL url = new URL("http://apis.symatapp.com/liccheck.php?email=" + PrefStorage.getSetting("license") + "&quick=1");
                    try (InputStream is = url.openStream();
                         BufferedReader br = new BufferedReader(new InputStreamReader(is));){
                        line = br.readLine();
                    }
                    if (line.equals("ok")) {
                        Main.licValid = true;
                    }
                }
                catch (Exception ex) {
                    Main.licValid = true;
                }
            }
        }

        private void checkUpdates() {
            try {
                Debug.println("Checking for updates...");
                URL url = new URL("http://apis.symatapp.com/version.php");
                InputStream is = url.openStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String line = br.readLine();
                br.close();
                is.close();
                double version = Double.parseDouble(line.split("\\|")[0]);
                if (version > 24.0) {
                    if (PrefStorage.getSetting("update-ignore").equals("2.1|" + line.split("\\|")[1])) {
                        System.out.println("An update was found, but has been ignored by the user.");
                    } else {
                        Debug.println("Update available.");
                        Main.updateString = line.split("\\|")[1];
                        Main.updateAvailable = true;
                    }
                } else {
                    Debug.println("No updates found.");
                }
            }
            catch (Exception e) {
                System.err.println("Fail:  Cannot check update server.  \n       Assuming local copy up-to-date.");
                Debug.stacktrace(e);
            }
        }

        private void setProgress(String label) {
            final String lbl = label;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SplashScreen.this.dispLabel.setText(lbl);
                }
            });
        }
    }
}

