/*
 * Decompiled with CFR 0.152.
 */
package net.apocalypselabs.symat;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import net.apocalypselabs.symat.Debug;
import net.apocalypselabs.symat.FileUtils;
import net.apocalypselabs.symat.License;

public class SharePad
extends JPanel {
    String padid = "";
    private JButton copyIDBtn;
    private JButton copyLinkBtn;
    private JTextField emailBox;
    private JButton emailBtn;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JTextField padIDBox;

    public SharePad(String id) {
        this.initComponents();
        this.padid = id;
        this.padIDBox.setText(this.padid);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.padIDBox = new JTextField();
        this.jPanel1 = new JPanel();
        this.copyIDBtn = new JButton();
        this.copyLinkBtn = new JButton();
        this.emailBtn = new JButton();
        this.emailBox = new JTextField();
        this.jLabel2 = new JLabel();
        this.setMinimumSize(new Dimension(188, 172));
        this.jLabel1.setText("Pad ID:");
        this.padIDBox.setEditable(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Share"));
        this.copyIDBtn.setText("Copy ID");
        this.copyIDBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharePad.this.copyIDBtnActionPerformed(evt);
            }
        });
        this.copyLinkBtn.setText("Copy Link");
        this.copyLinkBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharePad.this.copyLinkBtnActionPerformed(evt);
            }
        });
        this.emailBtn.setText("Send Email");
        this.emailBtn.setEnabled(false);
        this.emailBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharePad.this.emailBtnActionPerformed(evt);
            }
        });
        this.emailBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                SharePad.this.emailBoxKeyTyped(evt);
            }
        });
        this.jLabel2.setText("Email Link:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.copyIDBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.copyLinkBtn)).addComponent(this.emailBox).addComponent(this.emailBtn, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addGap(0, 0, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.copyIDBtn).addComponent(this.copyLinkBtn)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.emailBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.emailBtn).addGap(5, 5, 5)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel1, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.padIDBox))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(17, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.padIDBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2).addGap(7, 7, 7)));
    }

    private void copyIDBtnActionPerformed(ActionEvent evt) {
        this.toClipboard(this.padid);
    }

    private void copyLinkBtnActionPerformed(ActionEvent evt) {
        this.toClipboard("http://pad.symatapp.com/p/" + this.padid);
    }

    private void emailBtnActionPerformed(ActionEvent evt) {
        if (License.checkEmail(this.emailBox.getText())) {
            this.emailBtn.setEnabled(false);
            this.emailBtn.setText("Sending...");
            new EmailThread(this.emailBox.getText(), this.padid).start();
        }
    }

    private void emailBoxKeyTyped(KeyEvent evt) {
        this.emailBtn.setEnabled(License.checkEmail(this.emailBox.getText()));
    }

    private void toClipboard(String text) {
        StringSelection stringSelection = new StringSelection(text);
        Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
        clpbrd.setContents(stringSelection, null);
    }

    private class EmailThread
    extends Thread {
        private final String email;
        private final String pad;

        @Override
        public void run() {
            try {
                String f = FileUtils.getUrl("http://apis.symatapp.com/sendpad.php?email=" + this.email + "&padid=" + this.pad);
                Debug.println(f);
                if (f.contains("OK")) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SharePad.this.emailBtn.setText("Link Sent!");
                            SharePad.this.emailBox.setText("");
                        }
                    });
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SharePad.this.emailBtn.setText("Error.");
                        }
                    });
                }
            }
            catch (Exception ex) {
                Debug.stacktrace(ex);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SharePad.this.emailBtn.setText("Error, retry?");
                    }
                });
            }
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SharePad.this.emailBtn.setEnabled(License.checkEmail(SharePad.this.emailBox.getText()));
                    SharePad.this.emailBtn.setText("Send Email");
                }
            });
        }

        public EmailThread(String e, String p) {
            this.email = e;
            this.pad = p;
        }
    }
}

