/*
 * Decompiled with CFR 0.152.
 */
package net.apocalypselabs.symat;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import net.apocalypselabs.symat.Main;
import net.apocalypselabs.symat.PrefStorage;
import net.apocalypselabs.symat.Theme;

public class Settings
extends JInternalFrame {
    private JButton applyBtn;
    private JButton cancelBtn;
    private JButton clrRecentBtn;
    private JSpinner fontSizeSpinner;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JTabbedPane jTabbedPane1;
    private JTextField nameBox;
    private JCheckBox quickStart;
    private JButton saveBtn;
    private JCheckBox showRecent;
    private JCheckBox skipUpdates;
    private JComboBox themeBox;
    private ButtonGroup themeGroup;

    public Settings() {
        this.initComponents();
        this.setBackground(Theme.windowColor());
    }

    private void initComponents() {
        this.themeGroup = new ButtonGroup();
        this.saveBtn = new JButton();
        this.applyBtn = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel6 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel4 = new JLabel();
        this.themeBox = new JComboBox();
        this.jPanel5 = new JPanel();
        this.fontSizeSpinner = new JSpinner();
        this.jLabel5 = new JLabel();
        this.jPanel7 = new JPanel();
        this.quickStart = new JCheckBox();
        this.skipUpdates = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jPanel2 = new JPanel();
        this.showRecent = new JCheckBox();
        this.clrRecentBtn = new JButton();
        this.jPanel4 = new JPanel();
        this.jLabel1 = new JLabel();
        this.nameBox = new JTextField();
        this.jLabel6 = new JLabel();
        this.cancelBtn = new JButton();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setTitle("Settings");
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/net/apocalypselabs/symat/icons/settings.png")));
        this.setMaximumSize(new Dimension(9999, 9999));
        this.setMinimumSize(new Dimension(100, 100));
        this.setPreferredSize(new Dimension(449, 352));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                Settings.this.formComponentShown(evt);
            }
        });
        this.saveBtn.setText("OK");
        this.saveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Settings.this.saveBtnActionPerformed(evt);
            }
        });
        this.applyBtn.setText("Apply");
        this.applyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Settings.this.applyBtnActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Theme"));
        this.jPanel1.setToolTipText("Change the UI theme.");
        this.jLabel4.setText("<html><p>The dark theme is easier on the eyes at night.  The light theme should be used during the day for better visibility.</p></html>");
        this.jLabel4.setVerticalAlignment(1);
        this.themeBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Light", "Dark", "Neo"}));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4, -2, 0, Short.MAX_VALUE).addComponent(this.themeBox, 0, 154, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.themeBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel4).addContainerGap()));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder("Font Size"));
        this.fontSizeSpinner.setModel(new SpinnerNumberModel(12, 5, 48, 1));
        this.jLabel5.setText("<html><p>Set the font size for the Shell, Editor, Notepad, etc.</p></html>");
        this.jLabel5.setVerticalAlignment(1);
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5, -2, 79, -2).addComponent(this.fontSizeSpinner, -2, 67, -2)).addContainerGap(21, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.fontSizeSpinner, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel5, -1, 67, Short.MAX_VALUE).addContainerGap()));
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jPanel5, -2, -1, -2).addGap(220, 220, 220)));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addGap(93, 93, 93)));
        this.jTabbedPane1.addTab("Display", this.jPanel6);
        this.quickStart.setText("Quick Start");
        this.skipUpdates.setText("Skip Update Check");
        this.jLabel2.setText("<html><p>Quick Start skips some startup tasks,\nsuch as loading the Editor and Python engine. \nThese tasks will instead run when they are actually needed. \nThis will speed up application launch, \nbut slow down some operations the first time they are used,\n i.e. when the editor is launched or Python code is run.</p></html>");
        this.jLabel2.setVerticalAlignment(1);
        this.jLabel3.setText("<html><p>\nSkips checking for updates at startup.  If you do this, you should check for updates manually on the SyMAT website or in your email.\n</p></html>");
        this.jLabel3.setVerticalAlignment(1);
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.quickStart).addComponent(this.skipUpdates)).addGap(12, 12, 12).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2, -2, 0, Short.MAX_VALUE).addComponent(this.jLabel3, -1, 218, Short.MAX_VALUE)).addContainerGap(77, Short.MAX_VALUE)));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jLabel2, -2, 125, -2).addGap(18, 18, 18).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3, -2, -1, -2).addComponent(this.skipUpdates))).addComponent(this.quickStart)).addContainerGap(21, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Startup", this.jPanel7);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Recent Items"));
        this.showRecent.setSelected(true);
        this.showRecent.setText("Show recent items sidebar");
        this.clrRecentBtn.setText("Clear recent list");
        this.clrRecentBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Settings.this.clrRecentBtnActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.showRecent).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.clrRecentBtn, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.showRecent).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.clrRecentBtn).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Default Values"));
        this.jLabel1.setText("Your name:");
        this.jLabel6.setText("<html><p>Used in the code publishing tool as the default author name.</p></html>");
        this.jLabel6.setVerticalAlignment(1);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameBox).addComponent(this.jLabel1).addComponent(this.jLabel6, -2, 148, -2));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6, -1, 59, Short.MAX_VALUE).addContainerGap()));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addGap(203, 203, 203)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap(85, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Personalization", this.jPanel3);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Settings.this.cancelBtnActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.cancelBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.applyBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveBtn).addContainerGap()).addComponent(this.jTabbedPane1, -2, 433, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jTabbedPane1, -2, 263, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.applyBtn).addComponent(this.saveBtn).addComponent(this.cancelBtn)).addGap(30, 30, 30)));
        this.pack();
    }

    private void formComponentShown(ComponentEvent evt) {
        if (PrefStorage.isset("theme")) {
            switch (PrefStorage.getSetting("theme")) {
                case "dark": {
                    this.themeBox.setSelectedIndex(1);
                    break;
                }
                case "neo": {
                    this.themeBox.setSelectedIndex(2);
                    break;
                }
                default: {
                    this.themeBox.setSelectedIndex(0);
                }
            }
        }
        this.showRecent.setSelected(PrefStorage.getSetting("showrecent", "").equals(""));
        this.quickStart.setSelected(PrefStorage.getSetting("quickstart", "").equals("yes"));
        this.skipUpdates.setSelected(PrefStorage.getSetting("skipupdates", "").equals("yes"));
        this.nameBox.setText(PrefStorage.getSetting("author", ""));
        try {
            this.fontSizeSpinner.setValue(Integer.parseInt(PrefStorage.getSetting("editfont", "12")));
        }
        catch (Exception ex) {
            this.fontSizeSpinner.setValue(12);
        }
    }

    private void saveBtnActionPerformed(ActionEvent evt) {
        this.doSave();
        this.dispose();
    }

    private void doSave() {
        Theme.setTheme(this.themeBox.getSelectedItem().toString().toLowerCase());
        PrefStorage.saveSetting("showrecent", this.showRecent.isSelected() ? "" : "no");
        PrefStorage.saveSetting("quickstart", this.quickStart.isSelected() ? "yes" : "");
        PrefStorage.saveSetting("skipupdates", this.skipUpdates.isSelected() ? "yes" : "");
        PrefStorage.saveSetting("author", this.nameBox.getText());
        PrefStorage.saveSetting("editfont", this.fontSizeSpinner.getValue().toString());
        PrefStorage.save();
        Main.updateDisplay();
    }

    private void clrRecentBtnActionPerformed(ActionEvent evt) {
        PrefStorage.saveSetting("recentfiles", "");
        Main.loadRecentFiles();
    }

    private void applyBtnActionPerformed(ActionEvent evt) {
        this.doSave();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

