/*
 * Decompiled with CFR 0.152.
 */
package net.apocalypselabs.symat;

import java.io.File;
import java.io.IOException;
import javax.swing.JTextArea;
import net.apocalypselabs.symat.CodeRunner;
import net.apocalypselabs.symat.Debug;
import net.apocalypselabs.symat.FileUtils;
import net.apocalypselabs.symat.RunScriptListener;
import net.apocalypselabs.symat.ScriptOutputThread;

public class RunScriptThread
extends Thread {
    String lang = "";
    String code = "";
    ScriptOutputThread sot;
    CodeRunner cr;
    File filedata;
    JTextArea outputBox;
    RunScriptListener rsl = null;

    public RunScriptThread(String codelang, String script, JTextArea output, File fd) {
        this.lang = codelang;
        this.code = script;
        this.filedata = fd;
        this.outputBox = output;
        this.cr = new CodeRunner(this.lang);
        this.sot = new ScriptOutputThread(output, this.cr);
    }

    public void registerListener(RunScriptListener r) {
        this.rsl = r;
    }

    public void killme() {
        this.sot.kill();
        this.stop();
    }

    @Override
    public void run() {
        String script = this.loadExternalScripts(this.code, this.lang);
        Debug.println(this.lang);
        Debug.println(script);
        this.sot.start();
        this.cr.evalCode(script);
        this.sot.kill();
        this.rsl.scriptFinished();
    }

    private String loadExternalScripts(String script, String lang) {
        if (this.filedata == null) {
            return script;
        }
        String[] lines = script.split("\n");
        String result = "";
        String pre = "//";
        if (lang.startsWith("p")) {
            pre = "##";
        }
        for (String line : lines) {
            if (line.startsWith(pre + "include ") && !line.trim().endsWith(pre + "include")) {
                String temp = line.split(" ", 2)[1];
                try {
                    line = this.loadExternalScripts(FileUtils.readFile(this.filedata.getParent() + "./" + temp), lang);
                }
                catch (IOException ex) {
                    this.outputBox.append("Error: Cannot read referenced script file: " + ex.getMessage() + "\n");
                }
            }
            result = result + line + "\n";
        }
        return result;
    }
}

