/*
 * Decompiled with CFR 0.152.
 */
package net.apocalypselabs.symat;

import java.awt.Color;
import java.util.List;
import java.util.Map;
import syntaxhighlight.ParseResult;
import syntaxhighlight.Style;
import syntaxhighlight.Theme;

public class PrettifyToHtml {
    private static final String MAIN_CLASS = "prettyprint";

    public static String toHtml(String content, List<ParseResult> parseResults) {
        int endIndex = 0;
        StringBuilder sb = new StringBuilder();
        sb.append("<div class=\"prettyprint\">");
        sb.append("<pre>");
        for (ParseResult pr : parseResults) {
            int startIndex = pr.getOffset();
            if (startIndex > endIndex) {
                sb.append(content.substring(endIndex, startIndex));
            }
            endIndex = startIndex + pr.getLength();
            sb.append("<span class=\"" + pr.getStyleKeysString() + "\">");
            sb.append(content.substring(startIndex, endIndex));
            sb.append("</span>");
        }
        if (content.length() > endIndex) {
            sb.append(content.substring(endIndex, content.length()));
        }
        sb.append("</pre>");
        sb.append("</div>");
        return sb.toString();
    }

    public static String toCss(Theme theme) {
        StringBuilder sb = new StringBuilder();
        sb.append(".prettyprint  {");
        sb.append("font-family:monospace; ");
        PrettifyToHtml.appendCssColor(sb, "background-color", theme.getBackground());
        sb.append("}\n");
        for (Map.Entry entry : theme.getStyles().entrySet()) {
            sb.append(".prettyprint ." + (String)entry.getKey() + "  {");
            Style style = (Style)entry.getValue();
            PrettifyToHtml.appendCssColor(sb, "background-color", style.getBackground());
            PrettifyToHtml.appendCssColor(sb, "color", style.getColor());
            PrettifyToHtml.appendCssText(sb, "font-weight: bold", style.isBold());
            PrettifyToHtml.appendCssText(sb, "font-style: italic", style.isItalic());
            PrettifyToHtml.appendCssText(sb, "text-decoration: underline", style.isUnderline());
            sb.append("}\n");
        }
        theme.getStyles();
        return sb.toString();
    }

    private static void appendCssColor(StringBuilder sb, String cssKey, Color color) {
        if (color != null) {
            sb.append(cssKey + ": " + PrettifyToHtml.encode(color) + "; ");
        }
    }

    private static final String encode(Color color) {
        String s = Integer.toHexString(color.getRGB() & 0xFFFFFF);
        if (s.length() < 6) {
            s = "000000".substring(0, 6 - s.length()) + s;
        }
        return '#' + s;
    }

    private static void appendCssText(StringBuilder sb, String cssProp, boolean isSet) {
        if (isSet) {
            sb.append(cssProp + "; ");
        }
    }
}

