/*
 * Decompiled with CFR 0.152.
 */
package net.apocalypselabs.symat;

import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.http.message.BasicNameValuePair;

public class PrefStorage {
    private static final Preferences prefs = Preferences.userNodeForPackage(PrefStorage.class);

    public static void saveSetting(String key, String value) {
        prefs.put(key, value);
    }

    public static boolean isset(String key) {
        return !PrefStorage.getSetting(key, "NULL").equals("NULL");
    }

    public static void unset(String key) {
        PrefStorage.saveSetting(key, "");
        PrefStorage.save();
        prefs.remove(key);
        PrefStorage.save();
    }

    public static String getSetting(String key) {
        return prefs.get(key, "");
    }

    public static String getSetting(String key, String emptyResponse) {
        return prefs.get(key, emptyResponse);
    }

    public static boolean save() {
        try {
            prefs.flush();
            prefs.sync();
        }
        catch (BackingStoreException ex) {
            System.err.println("Settings could not be saved!");
            return false;
        }
        return true;
    }

    public static void wipe() throws BackingStoreException {
        prefs.clear();
    }

    public static List syncdump() throws BackingStoreException {
        String[] keys = prefs.keys();
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        for (String key : keys) {
            nvps.add(new BasicNameValuePair(key, prefs.get(key, "")));
        }
        return nvps;
    }

    int getRandomNumber() {
        return 4;
    }
}

