/*
 * Decompiled with CFR 0.152.
 */
package net.apocalypselabs.symat;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Random;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.apocalypselabs.symat.Debug;
import net.apocalypselabs.symat.Editor;
import net.apocalypselabs.symat.Main;
import net.apocalypselabs.symat.PadEditor;
import net.apocalypselabs.symat.PrefStorage;
import net.apocalypselabs.symat.SharePad;
import net.apocalypselabs.symat.Theme;
import org.etherpad_lite_client.EPLiteClient;
import org.etherpad_lite_client.EPLiteException;

public class Pads
extends JInternalFrame {
    public static final String PADS_URL = "http://pad.symatapp.com";
    private JButton addBtn;
    private JButton delBtn;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JButton openBtn;
    private JList padPane;
    private JButton previewBtn;
    private JTextArea previewPane;
    private JButton purgeBtn;
    private JButton saveBtn;
    private JButton shareBtn;

    public Pads() {
        this.initComponents();
        this.updateTheme();
        this.padPane.setListData(Pads.getPads());
    }

    private void updateTheme() {
        this.padPane.setBackground(Theme.boxColor());
        this.padPane.setForeground(Theme.textColor());
        this.previewPane.setBackground(Theme.boxColor());
        this.previewPane.setForeground(Theme.textColor());
        this.setBackground(Theme.windowColor());
    }

    public static void addPad(String id) {
        String pads = PrefStorage.getSetting("pads");
        for (String p : pads.split("\\|")) {
            if (!p.equals(id)) continue;
            return;
        }
        pads = pads.equals("") ? id : pads + "|" + id;
        PrefStorage.saveSetting("pads", pads);
    }

    public static void delPad(String id) {
        String pads = PrefStorage.getSetting("pads");
        String result = "";
        int i = 0;
        for (String pad : pads.split("\\|")) {
            if (pad.equals(id)) continue;
            if (i > 0) {
                result = result + "|";
            }
            result = result + pad;
            ++i;
        }
        PrefStorage.saveSetting("pads", result);
    }

    public static String[] getPads() {
        String pads = PrefStorage.getSetting("pads");
        if (!pads.equals("")) {
            if (pads.contains("|")) {
                return pads.split("\\|");
            }
            String[] padlist = new String[]{pads};
            return padlist;
        }
        String[] padlist = new String[]{};
        return padlist;
    }

    public static String genPad(String id, String content) throws Exception {
        if (id.equals("")) {
            id = Pads.genID();
        }
        try {
            Pads.getClient().createPad(id, content);
        }
        catch (EPLiteException ex) {
            Pads.getClient().setText(id, content);
        }
        return id;
    }

    public static String genID() {
        int length = 15;
        String[] chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".split("");
        String out = "";
        Random rng = new Random();
        for (int i = 0; i < length; ++i) {
            out = out + chars[rng.nextInt(chars.length)];
        }
        return out;
    }

    public static EPLiteClient getClient() throws Exception {
        String apikey;
        if (!PrefStorage.getSetting("padkey-override", "").equals("")) {
            apikey = PrefStorage.getSetting("padkey-override", "");
        } else {
            BufferedReader reader = new BufferedReader(new InputStreamReader(Pads.class.getResourceAsStream("/padkey")));
            apikey = reader.readLine();
        }
        return new EPLiteClient(PADS_URL, apikey);
    }

    public static String getPad(String id) {
        String text = "";
        try {
            text = Pads.getClient().getText(id).getOrDefault("text", "").toString();
        }
        catch (Exception ex) {
            text = "Error: " + ex.getMessage();
        }
        return text;
    }

    public static void setPad(String id, String content) {
        try {
            Pads.getClient().setText(id, content);
        }
        catch (Exception ex) {
            Debug.stacktrace(ex);
            JOptionPane.showInternalMessageDialog(Main.mainPane, "Could not sync pad contents: " + ex.getMessage(), "Error", 0);
        }
    }

    public static void delPad(String id, boolean purge) {
        Pads.delPad(id);
        if (purge) {
            try {
                Pads.getClient().deletePad(id);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void loadPad(String pad) {
        String theme = "?theme=";
        theme = Theme.currentTheme == 1 ? theme + "terminal" : theme + "default";
        Main.loadFrame(new PadEditor("http://pad.symatapp.com/p/" + pad + theme, pad));
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.padPane = new JList();
        this.jLabel1 = new JLabel();
        this.openBtn = new JButton();
        this.delBtn = new JButton();
        this.previewBtn = new JButton();
        this.saveBtn = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.previewPane = new JTextArea();
        this.shareBtn = new JButton();
        this.jLabel2 = new JLabel();
        this.purgeBtn = new JButton();
        this.addBtn = new JButton();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Collaboration");
        this.setMinimumSize(new Dimension(450, 280));
        this.setPreferredSize(new Dimension(450, 280));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                Pads.this.formMouseEntered(evt);
            }
        });
        this.padPane.setSelectionMode(0);
        this.padPane.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                Pads.this.padPaneValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.padPane);
        this.jLabel1.setText("My Pads:");
        this.openBtn.setText("Open");
        this.openBtn.setToolTipText("Open pad for editing");
        this.openBtn.setEnabled(false);
        this.openBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Pads.this.openBtnActionPerformed(evt);
            }
        });
        this.delBtn.setText("Delete");
        this.delBtn.setToolTipText("Remove pad from list");
        this.delBtn.setEnabled(false);
        this.delBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Pads.this.delBtnActionPerformed(evt);
            }
        });
        this.previewBtn.setText("Preview");
        this.previewBtn.setToolTipText("Preview pad contents");
        this.previewBtn.setEnabled(false);
        this.previewBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Pads.this.previewBtnActionPerformed(evt);
            }
        });
        this.saveBtn.setText("Download");
        this.saveBtn.setToolTipText("Save pad locally");
        this.saveBtn.setEnabled(false);
        this.saveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Pads.this.saveBtnActionPerformed(evt);
            }
        });
        this.previewPane.setEditable(false);
        this.previewPane.setColumns(1);
        this.previewPane.setRows(1);
        this.previewPane.setTabSize(4);
        this.jScrollPane2.setViewportView(this.previewPane);
        this.shareBtn.setText("Share");
        this.shareBtn.setToolTipText("Share pad");
        this.shareBtn.setEnabled(false);
        this.shareBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Pads.this.shareBtnActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Preview:");
        this.purgeBtn.setText("Purge");
        this.purgeBtn.setToolTipText("Delete pad completely");
        this.purgeBtn.setEnabled(false);
        this.purgeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Pads.this.purgeBtnActionPerformed(evt);
            }
        });
        this.addBtn.setText("+");
        this.addBtn.setToolTipText("Add pad by ID");
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Pads.this.addBtnActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jScrollPane1, -2, 132, -2).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel1, -2, 69, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.addBtn))).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.delBtn, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.saveBtn, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.openBtn, -1, -1, Short.MAX_VALUE).addComponent(this.previewBtn, -1, 84, Short.MAX_VALUE).addComponent(this.shareBtn, -1, -1, Short.MAX_VALUE).addComponent(this.purgeBtn, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addGap(0, 144, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.addBtn)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addComponent(this.openBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.delBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.purgeBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.previewBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.shareBtn))).addContainerGap()));
        this.pack();
    }

    private void delBtnActionPerformed(ActionEvent evt) {
        int ans = JOptionPane.showInternalConfirmDialog(this, "Remove pad from list?  It will not be removed from the server.", "Delete?", 2);
        if (ans == 0) {
            Pads.delPad(this.getSelectedPad());
        }
        this.updateList();
    }

    private void previewBtnActionPerformed(ActionEvent evt) {
        this.previewPane.setText(Pads.getPad(this.getSelectedPad()));
        this.updateList();
    }

    private void openBtnActionPerformed(ActionEvent evt) {
        Pads.loadPad(this.getSelectedPad());
    }

    private void purgeBtnActionPerformed(ActionEvent evt) {
        int ans = JOptionPane.showInternalConfirmDialog(this, "Remove pad from server and list?  This cannot be undone!", "Delete?", 2);
        if (ans == 0) {
            Pads.delPad(this.getSelectedPad(), true);
        }
        this.updateList();
    }

    private void saveBtnActionPerformed(ActionEvent evt) {
        Main.loadFrame(new Editor(Pads.getPad(this.getSelectedPad()), false));
        this.updateList();
    }

    private void padPaneValueChanged(ListSelectionEvent evt) {
        boolean enable = true;
        if (this.padPane.getSelectedValue() == null) {
            enable = false;
        }
        this.openBtn.setEnabled(enable);
        this.saveBtn.setEnabled(enable);
        this.delBtn.setEnabled(enable);
        this.shareBtn.setEnabled(enable);
        this.previewBtn.setEnabled(enable);
        this.purgeBtn.setEnabled(enable);
    }

    private void addBtnActionPerformed(ActionEvent evt) {
        String id = JOptionPane.showInternalInputDialog(this, "What is the pad ID?", "Add Pad", 3);
        if (id != null && !id.equals("")) {
            if (id.contains("pad.symatapp.com/p/")) {
                id = id.substring(id.lastIndexOf(47) + 1);
                Debug.println(id);
            }
            Pads.addPad(id);
        }
        this.updateList();
    }

    private void shareBtnActionPerformed(ActionEvent evt) {
        JOptionPane.showInternalMessageDialog(this, new SharePad(this.getSelectedPad()), "Share Pad", -1);
    }

    private void formMouseEntered(MouseEvent evt) {
        this.updateTheme();
    }

    private String getSelectedPad() {
        return this.padPane.getSelectedValue().toString();
    }

    private void updateList() {
        int sel = this.padPane.getSelectedIndex();
        this.padPane.setListData(Pads.getPads());
        try {
            this.padPane.setSelectedIndex(sel);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

