/*
 * Decompiled with CFR 0.152.
 */
package net.apocalypselabs.symat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.PromptData;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebView;
import javafx.util.Callback;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import net.apocalypselabs.symat.Main;
import net.apocalypselabs.symat.Pads;
import net.apocalypselabs.symat.RunScriptListener;
import net.apocalypselabs.symat.RunScriptThread;
import net.apocalypselabs.symat.Theme;

public class PadEditor
extends JInternalFrame
implements RunScriptListener {
    private WebView browser;
    private WebEngine webEngine;
    private JFXPanel jfxPanel;
    private Group root;
    private Scene scene;
    private String padID = "";
    private String padURL = "";
    private RunScriptThread rt;
    private JInternalFrame thisFrame;
    private JPanel browserBox;
    private JButton clearBtn;
    private JMenu codeLangMenu;
    private JLabel jLabel1;
    private JMenuBar jMenuBar1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JRadioButtonMenuItem javaOption;
    private JRadioButtonMenuItem javascriptOption;
    private JMenuItem killButton;
    private JTextArea outputBox;
    private JRadioButtonMenuItem pythonOption;
    private JMenuItem runCodeBtn;
    private JMenu runMenu;
    private JToolBar statusBar;
    private JLabel statusLbl;

    public PadEditor(final String padurl, String padid) {
        this.padID = padid;
        this.padURL = padurl;
        this.initComponents();
        this.thisFrame = this;
        this.jfxPanel = new JFXPanel();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                PadEditor.this.browser = new WebView();
                PadEditor.this.browser.setPrefSize((double)PadEditor.this.getWidth(), (double)PadEditor.this.getHeight());
                PadEditor.this.root = new Group();
                PadEditor.this.scene = new Scene((Parent)PadEditor.this.root);
                ObservableList children = PadEditor.this.root.getChildren();
                children.add((Object)PadEditor.this.browser);
                PadEditor.this.jfxPanel.setScene(PadEditor.this.scene);
                PadEditor.this.webEngine = PadEditor.this.browser.getEngine();
                PadEditor.this.webEngine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

                    public void changed(ObservableValue ov, Worker.State oldState, Worker.State newState) {
                        if (newState == Worker.State.RUNNING) {
                            PadEditor.this.statusLbl.setText("Loading...");
                        } else if (newState != Worker.State.SCHEDULED && newState != Worker.State.READY) {
                            PadEditor.this.statusLbl.setText("");
                        }
                    }
                });
                PadEditor.this.webEngine.setOnAlert((EventHandler)new EventHandler<WebEvent<String>>(){

                    public void handle(WebEvent<String> t) {
                        JOptionPane.showMessageDialog(PadEditor.this.thisFrame, t.getData(), "Message", 1);
                    }
                });
                PadEditor.this.webEngine.setPromptHandler((Callback)new Callback<PromptData, String>(){

                    public String call(PromptData p) {
                        return JOptionPane.showInputDialog(PadEditor.this.thisFrame, p.getMessage(), "Question", 3);
                    }
                });
                PadEditor.this.webEngine.setConfirmHandler((Callback)new Callback<String, Boolean>(){

                    public Boolean call(String p) {
                        return JOptionPane.showConfirmDialog(PadEditor.this.thisFrame, p, "Question", 2) == 0;
                    }
                });
                PadEditor.this.webEngine.setUserAgent("Mozilla/5.0 SyMAT/2.1");
                PadEditor.this.webEngine.loadContent("Loading...");
                PadEditor.this.webEngine.load(padurl);
            }
        });
        this.browserBox.add((Component)this.jfxPanel, "Center");
        this.outputBox.setBackground(Theme.boxColor());
        this.outputBox.setForeground(Theme.textColor());
    }

    public void loadURL(final String url) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                PadEditor.this.webEngine.load(url);
                PadEditor.this.resizeAll();
            }
        });
    }

    public void open() {
        Main.loadFrame(this, true);
    }

    public void loadString(final String content) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                PadEditor.this.webEngine.loadContent(content);
                PadEditor.this.resizeAll();
            }
        });
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.browserBox = new JPanel();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.outputBox = new JTextArea();
        this.clearBtn = new JButton();
        this.jLabel1 = new JLabel();
        this.statusBar = new JToolBar();
        this.statusLbl = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.runMenu = new JMenu();
        this.runCodeBtn = new JMenuItem();
        this.killButton = new JMenuItem();
        this.codeLangMenu = new JMenu();
        this.javascriptOption = new JRadioButtonMenuItem();
        this.pythonOption = new JRadioButtonMenuItem();
        this.javaOption = new JRadioButtonMenuItem();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Pad Editor");
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/net/apocalypselabs/symat/icons/editor.png")));
        this.setMinimumSize(new Dimension(300, 300));
        this.setPreferredSize(new Dimension(550, 391));
        this.addInternalFrameListener(new InternalFrameListener(){

            @Override
            public void internalFrameActivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent evt) {
                PadEditor.this.formInternalFrameOpened(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                PadEditor.this.formComponentResized(evt);
            }

            @Override
            public void componentShown(ComponentEvent evt) {
                PadEditor.this.formComponentShown(evt);
            }
        });
        this.jSplitPane1.setDividerLocation(200);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.7);
        this.jSplitPane1.setPreferredSize(new Dimension(550, 375));
        this.browserBox.setMinimumSize(new Dimension(100, 25));
        this.browserBox.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                PadEditor.this.browserBoxComponentResized(evt);
            }
        });
        this.browserBox.setLayout(new BorderLayout());
        this.jSplitPane1.setLeftComponent(this.browserBox);
        this.outputBox.setColumns(20);
        this.outputBox.setRows(1);
        this.outputBox.setTabSize(4);
        this.jScrollPane1.setViewportView(this.outputBox);
        this.clearBtn.setText("Clear");
        this.clearBtn.setToolTipText("");
        this.clearBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PadEditor.this.clearBtnActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Output:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 437, Short.MAX_VALUE).addComponent(this.clearBtn)).addComponent(this.jScrollPane1));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.clearBtn, -2, 18, -2)).addGap(0, 0, 0).addComponent(this.jScrollPane1, -1, 100, Short.MAX_VALUE)));
        this.jSplitPane1.setBottomComponent(this.jPanel1);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.statusBar.setFloatable(false);
        this.statusLbl.setText(" ");
        this.statusBar.add(this.statusLbl);
        this.getContentPane().add((Component)this.statusBar, "Last");
        this.runMenu.setText("Run");
        this.runCodeBtn.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.runCodeBtn.setText("Run code");
        this.runCodeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PadEditor.this.runCodeBtnActionPerformed(evt);
            }
        });
        this.runMenu.add(this.runCodeBtn);
        this.killButton.setText("Kill script");
        this.killButton.setEnabled(false);
        this.killButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PadEditor.this.killButtonActionPerformed(evt);
            }
        });
        this.runMenu.add(this.killButton);
        this.codeLangMenu.setText("Language");
        this.javascriptOption.setAccelerator(KeyStroke.getKeyStroke(74, 2));
        this.javascriptOption.setSelected(true);
        this.javascriptOption.setText("Javascript");
        this.javascriptOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PadEditor.this.javascriptOptionActionPerformed(evt);
            }
        });
        this.codeLangMenu.add(this.javascriptOption);
        this.pythonOption.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.pythonOption.setText("Python");
        this.pythonOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PadEditor.this.pythonOptionActionPerformed(evt);
            }
        });
        this.codeLangMenu.add(this.pythonOption);
        this.javaOption.setText("Java");
        this.javaOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PadEditor.this.javaOptionActionPerformed(evt);
            }
        });
        this.codeLangMenu.add(this.javaOption);
        this.runMenu.add(this.codeLangMenu);
        this.jMenuBar1.add(this.runMenu);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void formInternalFrameOpened(InternalFrameEvent evt) {
    }

    private void formComponentResized(ComponentEvent evt) {
        this.resizeAll();
    }

    private void formComponentShown(ComponentEvent evt) {
        this.resizeAll();
    }

    private void runCodeBtnActionPerformed(ActionEvent evt) {
        if (this.javascriptOption.isSelected()) {
            this.rt = new RunScriptThread("javascript", Pads.getPad(this.padID), this.outputBox, null);
        } else if (this.pythonOption.isSelected()) {
            this.rt = new RunScriptThread("python", Pads.getPad(this.padID), this.outputBox, null);
        } else if (this.javaOption.isSelected()) {
            this.rt = new RunScriptThread("java", Pads.getPad(this.padID), this.outputBox, null);
        } else {
            return;
        }
        this.statusLbl.setText("Running...");
        this.setRunning(true);
        this.rt.registerListener(this);
        this.rt.setDaemon(true);
        this.rt.start();
    }

    @Override
    public void scriptFinished() {
        this.statusLbl.setText("Done");
        this.setRunning(false);
    }

    private void killButtonActionPerformed(ActionEvent evt) {
        if (this.rt.isAlive()) {
            this.rt.killme();
            this.outputBox.append("\n=============\nScript killed\n=============\n");
        }
        this.statusLbl.setText("Killed");
        this.setRunning(false);
    }

    private void setRunning(boolean isRunning) {
        final boolean running = isRunning;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (running) {
                    for (Component mu : PadEditor.this.jMenuBar1.getComponents()) {
                        mu.setEnabled(false);
                    }
                    PadEditor.this.runMenu.setEnabled(true);
                    PadEditor.this.runCodeBtn.setEnabled(false);
                    PadEditor.this.codeLangMenu.setEnabled(false);
                    PadEditor.this.killButton.setEnabled(true);
                } else {
                    for (Component mu : PadEditor.this.jMenuBar1.getComponents()) {
                        mu.setEnabled(true);
                    }
                    PadEditor.this.runCodeBtn.setEnabled(true);
                    PadEditor.this.codeLangMenu.setEnabled(true);
                    PadEditor.this.killButton.setEnabled(false);
                }
            }
        });
    }

    private void javascriptOptionActionPerformed(ActionEvent evt) {
        this.pythonOption.setSelected(false);
        this.javaOption.setSelected(false);
        this.javascriptOption.setSelected(true);
    }

    private void pythonOptionActionPerformed(ActionEvent evt) {
        this.pythonOption.setSelected(true);
        this.javaOption.setSelected(false);
        this.javascriptOption.setSelected(false);
    }

    private void javaOptionActionPerformed(ActionEvent evt) {
        this.pythonOption.setSelected(false);
        this.javaOption.setSelected(true);
        this.javascriptOption.setSelected(false);
    }

    private void browserBoxComponentResized(ComponentEvent evt) {
        this.resizeAll();
    }

    private void clearBtnActionPerformed(ActionEvent evt) {
        this.outputBox.setText("");
    }

    private void resizeAll() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                PadEditor.this.jfxPanel.setSize(PadEditor.this.browserBox.getWidth(), PadEditor.this.browserBox.getHeight());
                PadEditor.this.browser.setPrefSize((double)PadEditor.this.browserBox.getWidth(), (double)PadEditor.this.browserBox.getHeight());
                PadEditor.this.browser.resize((double)PadEditor.this.browserBox.getWidth(), (double)PadEditor.this.browserBox.getHeight());
            }
        });
    }
}

