/*
 * Decompiled with CFR 0.152.
 */
package net.apocalypselabs.symat;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.apocalypselabs.symat.Debug;
import net.apocalypselabs.symat.FileUtils;
import net.apocalypselabs.symat.PrefStorage;
import net.apocalypselabs.symat.plugin.Plugin;

public class PackagePlugin
extends JInternalFrame {
    private final JFileChooser fcimg = new JFileChooser();
    private final JFileChooser fcexp = new JFileChooser();
    private ImageIcon icon;
    private JTextField author;
    private JTextArea codeBox;
    private JButton defaultIconBtn;
    private JLabel iconPreview;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTabbedPane jTabbedPane1;
    private JComboBox langSelect;
    private JTextArea longDesc;
    private JButton openIconBtn;
    private JTextField packageID;
    private JTextField pluginName;
    private JButton savePlugin;
    private JTextField shortDesc;
    private JTextField version;
    private JTextField website;

    public PackagePlugin(String code, int lang) {
        this();
        try {
            this.icon = new ImageIcon(ImageIO.read(PackagePlugin.class.getResource("images/plugin.png")));
        }
        catch (IOException ex) {
            Debug.stacktrace(ex);
        }
        this.langSelect.setSelectedIndex(lang);
        this.codeBox.setText(code);
        this.iconPreview.setIcon(this.icon);
    }

    public PackagePlugin() {
        this.fcimg.setFileFilter(new FileNameExtensionFilter("Image (jpeg,jpg,gif,png,bmp)", "jpeg", "jpg", "gif", "png", "bmp"));
        this.fcexp.setFileFilter(new FileNameExtensionFilter("Plugin (sypl)", "sypl"));
        this.initComponents();
        this.author.setText(PrefStorage.getSetting("author"));
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.pluginName = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.packageID = new JTextField();
        this.jLabel3 = new JLabel();
        this.website = new JTextField();
        this.jLabel4 = new JLabel();
        this.author = new JTextField();
        this.jLabel5 = new JLabel();
        this.version = new JTextField();
        this.jLabel6 = new JLabel();
        this.shortDesc = new JTextField();
        this.jLabel7 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.longDesc = new JTextArea();
        this.jPanel4 = new JPanel();
        this.jLabel9 = new JLabel();
        this.iconPreview = new JLabel();
        this.openIconBtn = new JButton();
        this.jLabel10 = new JLabel();
        this.defaultIconBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel8 = new JLabel();
        this.langSelect = new JComboBox();
        this.jScrollPane2 = new JScrollPane();
        this.codeBox = new JTextArea();
        this.jPanel3 = new JPanel();
        this.savePlugin = new JButton();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setTitle("Package Plugin");
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/net/apocalypselabs/symat/icons/plugins.png")));
        this.jLabel1.setText("Plugin Name:");
        this.jLabel2.setText("Package ID:");
        this.jLabel3.setText("Website:");
        this.jLabel4.setText("Author:");
        this.jLabel5.setText("Version:");
        this.jLabel6.setText("Description:");
        this.jLabel7.setText("Long Description:");
        this.longDesc.setColumns(20);
        this.longDesc.setRows(5);
        this.jScrollPane1.setViewportView(this.longDesc);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel7).addComponent(this.jScrollPane1, -1, 393, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel6, -2, 72, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.website, -1, 129, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.version, -1, 129, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.pluginName).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel4, -2, 39, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.author)).addComponent(this.packageID).addComponent(this.shortDesc)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.pluginName, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.author, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.packageID, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.website, -2, -1, -2).addComponent(this.jLabel5).addComponent(this.version, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.shortDesc, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 112, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Metadata", this.jPanel1);
        this.jLabel9.setText("Icon:");
        this.iconPreview.setHorizontalAlignment(0);
        this.iconPreview.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.openIconBtn.setText("Open icon...");
        this.openIconBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PackagePlugin.this.openIconBtnActionPerformed(evt);
            }
        });
        this.jLabel10.setText("Recommended icon size is 100x76.");
        this.jLabel10.setVerticalAlignment(1);
        this.defaultIconBtn.setText("Use default");
        this.defaultIconBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PackagePlugin.this.defaultIconBtnActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel10, -1, -1, Short.MAX_VALUE).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.iconPreview, -2, 115, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.openIconBtn, -1, -1, Short.MAX_VALUE).addComponent(this.defaultIconBtn, -1, -1, Short.MAX_VALUE))).addComponent(this.jLabel9)).addGap(0, 181, Short.MAX_VALUE))).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.openIconBtn).addGap(18, 18, 18).addComponent(this.defaultIconBtn)).addComponent(this.iconPreview, -2, 83, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel10, -1, 122, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Icon", this.jPanel4);
        this.jLabel8.setText("Language:");
        this.langSelect.setModel(new DefaultComboBoxModel<String>(new String[]{"JavaScript", "Python", "Java"}));
        this.codeBox.setColumns(20);
        this.codeBox.setRows(5);
        this.jScrollPane2.setViewportView(this.codeBox);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 393, Short.MAX_VALUE).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.langSelect, -2, 100, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.langSelect, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 210, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Code", this.jPanel2);
        this.savePlugin.setText("Save Plugin");
        this.savePlugin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PackagePlugin.this.savePluginActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(28, 28, 28).addComponent(this.savePlugin, -2, 150, -2).addContainerGap(235, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(27, 27, 27).addComponent(this.savePlugin, -2, 100, -2).addContainerGap(131, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Publish", this.jPanel3);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1));
        this.pack();
    }

    private void savePluginActionPerformed(ActionEvent evt) {
        Plugin p = new Plugin();
        try {
            p.setTitle(this.pluginName.getText());
            p.setAuthor(this.author.getText());
            p.setLongTitle(this.shortDesc.getText());
            p.setDesc(this.longDesc.getText());
            p.setPackage(this.packageID.getText());
            p.setVersion(this.version.getText());
            p.setWebsite(this.website.getText());
            p.setLang(this.langSelect.getSelectedIndex());
            p.setScript(this.codeBox.getText());
            p.setIcon(this.icon);
            if (p.getTitle().equals("") || p.getAuthor().equals("") || p.getPackage().equals("") || p.getVersion().equals("") || p.getScript().equals("") || p.getIcon() == null) {
                throw new Exception("One or more required fields are empty.");
            }
        }
        catch (Exception ex) {
            Debug.stacktrace(ex);
            JOptionPane.showInternalMessageDialog(this, "Error.  Please check your data.\n\n" + ex.getMessage());
            return;
        }
        int result = this.fcexp.showDialog(this, "Publish");
        if (result == 0) {
            try {
                FileOutputStream fout = new FileOutputStream(FileUtils.getFileWithExtension(this.fcexp));
                try (ObjectOutputStream oos = new ObjectOutputStream(fout);){
                    oos.writeObject(p);
                    oos.close();
                }
                JOptionPane.showInternalMessageDialog(this, "Publish complete!");
            }
            catch (Exception ex) {
                Debug.stacktrace(ex);
                JOptionPane.showInternalMessageDialog(this, "Error saving file.\n\n" + ex.getMessage());
            }
        }
    }

    private void openIconBtnActionPerformed(ActionEvent evt) {
        int result = this.fcimg.showDialog(this, "Select Icon");
        if (result == 0) {
            try {
                this.icon = new ImageIcon(ImageIO.read(this.fcimg.getSelectedFile()));
                this.iconPreview.setIcon(this.icon);
            }
            catch (Exception ex) {
                Debug.stacktrace(ex);
                JOptionPane.showInternalMessageDialog(this, "Error opening image.\n\n" + ex.getMessage());
            }
        }
    }

    private void defaultIconBtnActionPerformed(ActionEvent evt) {
        try {
            this.icon = new ImageIcon(ImageIO.read(PackagePlugin.class.getResource("images/plugin.png")));
            this.iconPreview.setIcon(this.icon);
        }
        catch (IOException ex) {
            Debug.stacktrace(ex);
            JOptionPane.showInternalMessageDialog(this, "Error opening default icon.\n\n" + ex.getMessage());
        }
    }
}

