/*
 * Decompiled with CFR 0.152.
 */
package net.apocalypselabs.symat;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.apocalypselabs.symat.FileUtils;
import net.apocalypselabs.symat.Main;
import net.apocalypselabs.symat.PrefStorage;
import net.apocalypselabs.symat.Theme;

public class Notepad
extends JInternalFrame {
    private JMenuItem eraseBtn;
    private JMenuItem exportBtn;
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JScrollPane jScrollPane1;
    private JTextArea textBox;

    public Notepad() {
        this.initComponents();
        int font_size = 12;
        try {
            font_size = Integer.valueOf(PrefStorage.getSetting("editfont", "12"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.textBox.setFont(Main.ubuntuRegular.deriveFont((float)font_size));
        this.textBox.setText(PrefStorage.getSetting("notepad"));
        this.loadTheme();
    }

    private void loadTheme() {
        this.textBox.setBackground(Theme.notepadColor());
        this.textBox.setForeground(Theme.textColor());
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.textBox = new JTextArea();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.exportBtn = new JMenuItem();
        this.eraseBtn = new JMenuItem();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Notepad");
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/net/apocalypselabs/symat/icons/notepad.png")));
        this.addInternalFrameListener(new InternalFrameListener(){

            @Override
            public void internalFrameActivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent evt) {
                Notepad.this.formInternalFrameClosing(evt);
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent evt) {
            }
        });
        this.textBox.setBackground(new Color(255, 255, 204));
        this.textBox.setColumns(1);
        this.textBox.setLineWrap(true);
        this.textBox.setRows(1);
        this.textBox.setTabSize(4);
        this.textBox.setWrapStyleWord(true);
        this.textBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Notepad.this.textBoxMouseClicked(evt);
            }
        });
        this.textBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                Notepad.this.textBoxKeyTyped(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.textBox);
        this.jMenu1.setText("File");
        this.exportBtn.setText("Export text");
        this.exportBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Notepad.this.exportBtnActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.exportBtn);
        this.eraseBtn.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.eraseBtn.setText("Erase");
        this.eraseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Notepad.this.eraseBtnActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.eraseBtn);
        this.jMenuBar1.add(this.jMenu1);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 394, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 277, Short.MAX_VALUE));
        this.pack();
    }

    private void eraseBtnActionPerformed(ActionEvent evt) {
        int ans = JOptionPane.showInternalConfirmDialog(this, "Erase notepad contents?", "Are you sure?", 0);
        if (ans == 0) {
            this.textBox.setText("");
            this.save();
        }
    }

    private void textBoxKeyTyped(KeyEvent evt) {
        this.save();
    }

    private void exportBtnActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Plain Text (.txt)", "txt");
        fc.setFileFilter(filter);
        fc.addChoosableFileFilter(filter);
        int result = fc.showSaveDialog(this);
        if (result == 0) {
            try {
                FileUtils.saveFile(this.textBox.getText(), FileUtils.getFileWithExtension(fc).toString(), false);
            }
            catch (IOException ex) {
                JOptionPane.showInternalMessageDialog(this, "Error saving: " + ex.getMessage(), "Error", 0);
            }
        }
    }

    private void formInternalFrameClosing(InternalFrameEvent evt) {
        this.save();
    }

    private void textBoxMouseClicked(MouseEvent evt) {
        this.loadTheme();
    }

    private void save() {
        PrefStorage.saveSetting("notepad", this.textBox.getText());
    }
}

