/*
 * Decompiled with CFR 0.152.
 */
package net.apocalypselabs.symat;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.apocalypselabs.symat.Debug;
import net.apocalypselabs.symat.Editor;
import net.apocalypselabs.symat.ExitControl;
import net.apocalypselabs.symat.Graph;
import net.apocalypselabs.symat.Help;
import net.apocalypselabs.symat.InstallPlugin;
import net.apocalypselabs.symat.Interpreter;
import net.apocalypselabs.symat.KeyValListItem;
import net.apocalypselabs.symat.License;
import net.apocalypselabs.symat.Notepad;
import net.apocalypselabs.symat.Pads;
import net.apocalypselabs.symat.PrefStorage;
import net.apocalypselabs.symat.Settings;
import net.apocalypselabs.symat.SingleInstanceClient;
import net.apocalypselabs.symat.SingleInstanceServer;
import net.apocalypselabs.symat.SplashScreen;
import net.apocalypselabs.symat.Tasks;
import net.apocalypselabs.symat.Theme;
import net.apocalypselabs.symat.Update;
import net.apocalypselabs.symat.WebBrowser;
import net.apocalypselabs.symat.plugin.LoadPlugin;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandToggleButton;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.StringValuePair;
import org.pushingpixels.flamingo.api.common.icon.ImageWrapperResizableIcon;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbonFrame;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenu;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenuEntryFooter;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenuEntryPrimary;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenuEntrySecondary;
import org.pushingpixels.flamingo.api.ribbon.RibbonElementPriority;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;
import org.pushingpixels.flamingo.api.ribbon.resize.CoreRibbonResizePolicies;
import org.pushingpixels.flamingo.api.ribbon.resize.IconRibbonBandResizePolicy;
import org.pushingpixels.flamingo.internal.ui.ribbon.JBandControlPanel;

public class Main
extends JRibbonFrame {
    public static final String VERSION_NAME = "2.1";
    public static final String SYMAT = "SyMAT";
    public static final String APP_NAME = "SyMAT 2.1";
    public static final double APP_CODE = 24.0;
    public static final String API_URL = "http://apis.symatapp.com/";
    public static String argfile = "";
    public static Font ubuntuRegular;
    public static boolean skipPython;
    public static boolean skipEditor;
    private static boolean recentItemsMinimized;
    public static boolean updateAvailable;
    public static String updateString;
    public static boolean licValid;
    public static ArrayList<Image> symatlogo;
    public static SingleInstanceServer sisrv;
    public static Main maingui;
    public JRibbonBand pluginband;
    public static JCommandButton shellbtn;
    public static JCommandButton editorbtn;
    public static JCommandButton graphbtn;
    public static JCommandButton notepadbtn;
    public static JCommandButton wikibtn;
    public static JCommandButton browserbtn;
    public static JCommandButton padsbtn;
    public static JCommandButton tasksbtn;
    public static JCommandButton installpluginbtn;
    public static RibbonApplicationMenuEntryPrimary openbtn;
    public static JPanel appPanel;
    public static JLabel jLabel2;
    public static JMenuItem jMenuItem1;
    public static JScrollPane jScrollPane1;
    public static JDesktopPane mainPane;
    public static JButton recentFileBtn;
    public static JList recentFileList;
    public static JPanel recentItemsPanel;
    public static JLabel recentItemsTitle;

    public Main() {
        GregorianCalendar piday;
        maingui = this;
        this.setIconImages(symatlogo);
        this.initComponents();
        this.loadRibbon();
        this.setLocationRelativeTo(null);
        this.addWindowListener(new ExitControl());
        boolean loaded = false;
        if (!argfile.equals("")) {
            if (argfile.endsWith(".sytt")) {
                Tasks tt = new Tasks(new File(argfile));
                Main.loadFrame(tt);
                argfile = "";
            } else if (argfile.endsWith(".sypl")) {
                Main.loadFrame(new InstallPlugin(new File(argfile)));
            } else {
                Editor ed = new Editor();
                Main.loadFrame(ed);
                ed.openFileFromName(argfile);
                argfile = "";
            }
            loaded = true;
        }
        if (!licValid) {
            Main.licenseRestrict(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Main.loadFrame(new License());
                }
            });
            loaded = true;
        }
        if (argfile.equals("") && !loaded) {
            Main.loadFrame(new Interpreter());
        }
        if (updateAvailable) {
            Main.loadFrame(new Update(updateString));
        }
        Main.loadRecentFiles();
        Main.updateDisplay();
        this.setVisible(true);
        if (PrefStorage.getSetting("framemaxed", "no").equals("yes")) {
            EventQueue.invokeLater(() -> this.setExtendedState(6));
        }
        if (!PrefStorage.getSetting("showrecent", "").equals("")) {
            recentItemsPanel.setVisible(false);
        }
        if ((piday = new GregorianCalendar()).get(2) == 2 && piday.get(5) == 14) {
            JOptionPane.showInternalMessageDialog(mainPane, "Happy Pi Day from the SyMAT team!", "3/14", -1);
        }
    }

    public void loadPlugins() {
        this.pluginband = new JRibbonBand("Plugins", null);
        installpluginbtn.setActionRichTooltip(new RichTooltip("Install Plugin", "Install a plugin from a file and view plugin info."));
        installpluginbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.loadFrame(new InstallPlugin());
            }
        });
        this.pluginband.setResizePolicies(Arrays.asList(new CoreRibbonResizePolicies.Mirror((JBandControlPanel)this.pluginband.getControlPanel())));
        this.pluginband.addCommandButton((AbstractCommandButton)installpluginbtn, RibbonElementPriority.TOP);
        String fsep = System.getProperty("file.separator");
        File dir = new File(System.getProperty("user.home") + fsep + ".symat" + fsep + "plugins");
        dir.mkdirs();
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".sypl");
            }
        });
        HashMap<RibbonElementPriority, Integer> galleryVisibleButtonCounts = new HashMap<RibbonElementPriority, Integer>();
        galleryVisibleButtonCounts.put(RibbonElementPriority.LOW, 4);
        galleryVisibleButtonCounts.put(RibbonElementPriority.MEDIUM, 4);
        galleryVisibleButtonCounts.put(RibbonElementPriority.TOP, 4);
        ArrayList<StringValuePair> appGalleryButtons = new ArrayList<StringValuePair>();
        ArrayList<JCommandToggleButton> appGalleryButtonsList = new ArrayList<JCommandToggleButton>();
        if (files != null) {
            for (File pl : files) {
                try {
                    LoadPlugin lp = new LoadPlugin(pl);
                    appGalleryButtonsList.add(lp.getGalleryBtn());
                }
                catch (Exception ex) {
                    Debug.stacktrace(ex);
                    System.err.println("Error loading plugin " + pl.getName() + ": " + ex.getMessage());
                }
            }
        }
        appGalleryButtons.add(new StringValuePair("Plugins", appGalleryButtonsList));
        this.pluginband.addRibbonGallery("Plugins", appGalleryButtons, galleryVisibleButtonCounts, 4, 3, RibbonElementPriority.TOP);
    }

    public void reloadRibbon() {
        this.getRibbon().removeAllTasks();
        this.loadRibbon();
    }

    private void loadRibbon() {
        ImageWrapperResizableIcon appico = ImageWrapperResizableIcon.getIcon((URL)Main.class.getResource("32x32.png"), (Dimension)new Dimension(32, 32));
        this.setApplicationIcon((ResizableIcon)appico);
        for (int tries = 0; tries < 20; ++tries) {
            try {
                Thread.sleep(10L);
                if (this.getApplicationIcon().equals(appico)) break;
                this.setApplicationIcon((ResizableIcon)appico);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        JRibbon ribbon = this.getRibbon();
        JRibbonBand codeband = new JRibbonBand("Code", null);
        JRibbonBand toolsband = new JRibbonBand("Tools", null);
        JRibbonBand webband = new JRibbonBand("Web", null);
        JRibbonBand collabband = new JRibbonBand("Team", null);
        try {
            this.loadPlugins();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog((Component)((Object)this), "An error occurred while loading plugins: " + ex.getMessage());
        }
        shellbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.loadFrame(new Interpreter());
            }
        });
        editorbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.loadFrame(new Editor());
            }
        });
        graphbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.loadFrame(new Graph());
            }
        });
        notepadbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.loadFrame(new Notepad());
            }
        });
        wikibtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.loadFrame(new WebBrowser("SyMAT Wiki", "http://wiki.symatapp.com", 1));
            }
        });
        browserbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.loadFrame(new WebBrowser());
            }
        });
        padsbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.loadFrame(new Pads());
            }
        });
        tasksbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.loadFrame(new Tasks());
            }
        });
        shellbtn.setActionRichTooltip(new RichTooltip("Command Shell", "Open a window for running interactive commands."));
        editorbtn.setActionRichTooltip(new RichTooltip("Code Editor", "Write and run JavaScript and Python scripts."));
        graphbtn.setActionRichTooltip(new RichTooltip("Graph", "Plot mathematical functions on a 2D graph."));
        notepadbtn.setActionRichTooltip(new RichTooltip("Notepad", "Write quick notes on a virtual napkin."));
        wikibtn.setActionRichTooltip(new RichTooltip("SyMAT Wiki", "View and edit online documentation and tutorials."));
        browserbtn.setActionRichTooltip(new RichTooltip("Web Browser", "Go online and browse the web."));
        padsbtn.setActionRichTooltip(new RichTooltip("Code Pads", "Collaborate over the Internet on projects."));
        tasksbtn.setActionRichTooltip(new RichTooltip("Task List", "Manage tasks and to-do lists for projects."));
        codeband.addCommandButton((AbstractCommandButton)shellbtn, RibbonElementPriority.TOP);
        codeband.addCommandButton((AbstractCommandButton)editorbtn, RibbonElementPriority.TOP);
        toolsband.addCommandButton((AbstractCommandButton)graphbtn, RibbonElementPriority.MEDIUM);
        toolsband.addCommandButton((AbstractCommandButton)notepadbtn, RibbonElementPriority.MEDIUM);
        toolsband.addCommandButton((AbstractCommandButton)tasksbtn, RibbonElementPriority.MEDIUM);
        webband.addCommandButton((AbstractCommandButton)padsbtn, RibbonElementPriority.TOP);
        webband.addCommandButton((AbstractCommandButton)browserbtn, RibbonElementPriority.MEDIUM);
        webband.addCommandButton((AbstractCommandButton)wikibtn, RibbonElementPriority.MEDIUM);
        codeband.setResizePolicies(Arrays.asList(new CoreRibbonResizePolicies.None((JBandControlPanel)codeband.getControlPanel()), new IconRibbonBandResizePolicy(codeband.getControlPanel())));
        toolsband.setResizePolicies(Arrays.asList(new CoreRibbonResizePolicies.None((JBandControlPanel)toolsband.getControlPanel()), new IconRibbonBandResizePolicy(toolsband.getControlPanel())));
        webband.setResizePolicies(Arrays.asList(new CoreRibbonResizePolicies.None((JBandControlPanel)webband.getControlPanel()), new IconRibbonBandResizePolicy(webband.getControlPanel())));
        collabband.setResizePolicies(Arrays.asList(new CoreRibbonResizePolicies.None((JBandControlPanel)collabband.getControlPanel()), new IconRibbonBandResizePolicy(collabband.getControlPanel())));
        RibbonTask hometask = new RibbonTask("Apps", new AbstractRibbonBand[]{codeband, toolsband, webband});
        RibbonTask plugintask = new RibbonTask("Plugins", new AbstractRibbonBand[]{this.pluginband});
        Main.loadRibbonMenu(null);
        ribbon.addTask(hometask);
        ribbon.addTask(plugintask);
    }

    public static ResizableIcon getRibbonIcon(String name) {
        return ImageWrapperResizableIcon.getIcon((URL)Main.class.getResource("images/" + name + ".png"), (Dimension)new Dimension(100, 76));
    }

    public static ResizableIcon getTinyRibbonIcon(String name) {
        int d = 32;
        return ImageWrapperResizableIcon.getIcon((URL)Main.class.getResource("icons/" + name + ".png"), (Dimension)new Dimension(d, d));
    }

    public static void licenseRestrict(boolean restricted) {
        graphbtn.setEnabled(!restricted);
        padsbtn.setEnabled(!restricted);
        recentFileList.setEnabled(!restricted);
    }

    public static void updateDisplay() {
        maingui.getRibbon().setBackground(Theme.tabColor());
        recentFileList.setForeground(Theme.textColor());
        recentFileList.setBackground(Theme.boxColor());
        recentItemsPanel.setVisible(PrefStorage.getSetting("showrecent", "").equals(""));
        maingui.getRibbon().setMinimized(PrefStorage.getSetting("miniribbon", "").equals("yes"));
        mainPane.paintImmediately(0, 0, mainPane.getWidth(), mainPane.getHeight());
    }

    public static void loadRibbonMenu(RibbonApplicationMenuEntrySecondary[] recent) {
        RibbonApplicationMenuEntryPrimary helpbtn = new RibbonApplicationMenuEntryPrimary(Main.getRibbonIcon("help"), "Manual", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.loadFrame(new Help());
            }
        }, JCommandButton.CommandButtonKind.ACTION_ONLY);
        RibbonApplicationMenuEntryPrimary cascadebtn = new RibbonApplicationMenuEntryPrimary(Main.getRibbonIcon("cascade"), "Arrange all", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.cascade();
            }
        }, JCommandButton.CommandButtonKind.ACTION_ONLY);
        RibbonApplicationMenuEntryPrimary exitbtn = new RibbonApplicationMenuEntryPrimary(Main.getRibbonIcon("closeall"), "Exit", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                maingui.dispatchEvent(new WindowEvent((Window)((Object)maingui), 201));
            }
        }, JCommandButton.CommandButtonKind.ACTION_ONLY);
        RibbonApplicationMenuEntrySecondary newjsbtn = new RibbonApplicationMenuEntrySecondary(Main.getTinyRibbonIcon("jsicon"), "JavaScript", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.loadFrame(new Editor(1));
            }
        }, JCommandButton.CommandButtonKind.ACTION_ONLY);
        RibbonApplicationMenuEntrySecondary newpybtn = new RibbonApplicationMenuEntrySecondary(Main.getTinyRibbonIcon("pyicon"), "Python", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.loadFrame(new Editor(2));
            }
        }, JCommandButton.CommandButtonKind.ACTION_ONLY);
        RibbonApplicationMenuEntrySecondary newjavabtn = new RibbonApplicationMenuEntrySecondary(Main.getTinyRibbonIcon("jaicon"), "Java", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.loadFrame(new Editor(3));
            }
        }, JCommandButton.CommandButtonKind.ACTION_ONLY);
        RibbonApplicationMenuEntrySecondary newtaskbtn = new RibbonApplicationMenuEntrySecondary(Main.getTinyRibbonIcon("taskicon"), "Task List", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.loadFrame(new Tasks());
            }
        }, JCommandButton.CommandButtonKind.ACTION_ONLY);
        RibbonApplicationMenuEntryPrimary newbtn = new RibbonApplicationMenuEntryPrimary(Main.getRibbonIcon("newfile"), "New", null, JCommandButton.CommandButtonKind.POPUP_ONLY);
        openbtn = new RibbonApplicationMenuEntryPrimary(Main.getRibbonIcon("openfile"), "Open", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFileChooser fc = new JFileChooser();
                FileNameExtensionFilter script = new FileNameExtensionFilter("Script(syjs, sypy, js, py)", "syjs", "sypy", "js", "py");
                FileNameExtensionFilter all = new FileNameExtensionFilter("SyMAT File(syjs, sypy, js, py, sytt)", "syjs", "sypy", "js", "py", "sytt");
                FileNameExtensionFilter tasklist = new FileNameExtensionFilter("Task List (sytt)", "sytt");
                fc.setFileFilter(all);
                fc.addChoosableFileFilter(script);
                fc.addChoosableFileFilter(tasklist);
                int result = fc.showOpenDialog((Component)((Object)maingui));
                if (result == 0) {
                    File f = fc.getSelectedFile();
                    if (f.getName().endsWith(".sytt")) {
                        Main.loadFrame(new Tasks(f));
                    } else {
                        Editor ed = new Editor();
                        ed.openFileFromName(f.getAbsolutePath());
                        Main.loadFrame(ed);
                    }
                }
            }
        }, JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
        if (recent == null) {
            RibbonApplicationMenuEntrySecondary blanksubbtn = new RibbonApplicationMenuEntrySecondary(null, "No recent files", null, JCommandButton.CommandButtonKind.ACTION_ONLY);
            blanksubbtn.setEnabled(false);
            openbtn.addSecondaryMenuGroup("Recent Files", new RibbonApplicationMenuEntrySecondary[]{blanksubbtn});
        } else {
            openbtn.addSecondaryMenuGroup("Recent Files", recent);
        }
        newbtn.addSecondaryMenuGroup("Code File", new RibbonApplicationMenuEntrySecondary[]{newjsbtn, newpybtn, newjavabtn});
        newbtn.addSecondaryMenuGroup("Other", new RibbonApplicationMenuEntrySecondary[]{newtaskbtn});
        RibbonApplicationMenuEntryFooter displaybtn = new RibbonApplicationMenuEntryFooter(Main.getTinyRibbonIcon("settings"), "Settings", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.loadFrame(new Settings());
            }
        });
        RibbonApplicationMenuEntryPrimary blankbtn = new RibbonApplicationMenuEntryPrimary(null, "", null, JCommandButton.CommandButtonKind.ACTION_ONLY);
        blankbtn.setEnabled(false);
        RibbonApplicationMenu menu = new RibbonApplicationMenu();
        menu.addMenuEntry(newbtn);
        menu.addMenuEntry(openbtn);
        menu.addMenuSeparator();
        menu.addMenuEntry(helpbtn);
        menu.addMenuEntry(cascadebtn);
        menu.addMenuSeparator();
        menu.addMenuEntry(exitbtn);
        menu.addFooterEntry(displaybtn);
        menu.addMenuEntry(blankbtn);
        menu.addMenuEntry(blankbtn);
        menu.addMenuEntry(blankbtn);
        menu.addMenuEntry(blankbtn);
        maingui.getRibbon().setApplicationMenu(menu);
        maingui.getRibbon().setApplicationMenuRichTooltip(new RichTooltip("SyMAT Menu", "Create files, open documents, get help, and change settings"));
    }

    /*
     * WARNING - void declaration
     */
    public static void loadRecentFiles() {
        void var6_10;
        String files = PrefStorage.getSetting("recentfiles");
        if (files.equals("")) {
            Main.loadRibbonMenu(null);
            recentFileList.setListData(new String[0]);
            return;
        }
        String[] fileList = files.split("\n");
        int neededLength = 0;
        for (String string : fileList) {
            if (!new File(string).isFile()) continue;
            ++neededLength;
        }
        if (neededLength > 10) {
            neededLength = 10;
        }
        KeyValListItem[] items = new KeyValListItem[neededLength];
        int i = 0;
        RibbonApplicationMenuEntrySecondary[] recentmenu = new RibbonApplicationMenuEntrySecondary[fileList.length];
        for (String f : fileList) {
            final File file = new File(f);
            if (!file.isFile() || i >= neededLength) continue;
            items[i] = new KeyValListItem(file.getName(), file.getPath());
            recentmenu[i] = new RibbonApplicationMenuEntrySecondary(null, file.getName(), new ActionListener(){
                final String path;
                {
                    this.path = file.getPath();
                }

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Editor edit = new Editor();
                    edit.openFileFromName(this.path);
                    Main.loadFrame(edit);
                }
            }, JCommandButton.CommandButtonKind.ACTION_ONLY);
            ++i;
        }
        Main.loadRibbonMenu(recentmenu);
        recentFileList.setListData(items);
        String string = "";
        for (KeyValListItem item : items) {
            String string2 = (String)var6_10 + item.getValue() + "\n";
        }
        PrefStorage.saveSetting("recentfiles", (String)var6_10);
    }

    public static void addRecentFile(String file) {
        file = new File(file).getAbsolutePath();
        String files = PrefStorage.getSetting("recentfiles");
        String[] fileList = files.split("\n");
        for (int i = 0; i < fileList.length; ++i) {
            if (!fileList[i].trim().equals(file)) continue;
            fileList[i] = "";
        }
        files = file + "\n";
        for (String f : fileList) {
            if (f.trim().equals("")) continue;
            files = files + f + "\n";
        }
        PrefStorage.saveSetting("recentfiles", files);
        PrefStorage.save();
        Main.loadRecentFiles();
    }

    private void initComponents() {
        jMenuItem1 = new JMenuItem();
        mainPane = new JDesktopPane(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(Theme.windowColor());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        };
        jLabel2 = new JLabel();
        recentItemsPanel = new JPanel();
        jScrollPane1 = new JScrollPane();
        recentFileList = new JList();
        recentFileBtn = new JButton();
        recentItemsTitle = new JLabel();
        appPanel = new JPanel();
        jMenuItem1.setText("jMenuItem1");
        this.setDefaultCloseOperation(0);
        this.setTitle(SYMAT);
        this.setMinimumSize(new Dimension(640, 540));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                Main.this.formComponentShown(evt);
            }
        });
        mainPane.setBackground(new Color(204, 204, 204));
        mainPane.setAutoscrolls(true);
        mainPane.setCursor(new Cursor(0));
        mainPane.setOpaque(false);
        jLabel2.setFont(ubuntuRegular.deriveFont(48.0f));
        jLabel2.setForeground(new Color(153, 153, 153));
        jLabel2.setHorizontalAlignment(11);
        jLabel2.setText(SYMAT);
        jLabel2.setVerticalAlignment(3);
        recentItemsPanel.setBorder(BorderFactory.createEtchedBorder());
        recentItemsPanel.setForeground(new Color(153, 153, 153));
        recentItemsPanel.setMaximumSize(new Dimension(160, 273));
        recentItemsPanel.setOpaque(false);
        jScrollPane1.setMinimumSize(new Dimension(23, 206));
        jScrollPane1.setName("");
        recentFileList.setSelectionMode(0);
        recentFileList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Main.this.recentFileListMouseClicked(evt);
            }
        });
        recentFileList.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                Main.this.recentFileListMouseMoved(evt);
            }
        });
        jScrollPane1.setViewportView(recentFileList);
        recentFileBtn.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/net/apocalypselabs/symat/icons/openfile.png")));
        recentFileBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.recentFileBtnActionPerformed(evt);
            }
        });
        recentItemsTitle.setFont(new Font("Tahoma", 1, 12));
        recentItemsTitle.setForeground(new Color(102, 102, 102));
        recentItemsTitle.setText("  Recent Files");
        recentItemsTitle.setOpaque(true);
        recentItemsTitle.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Main.this.recentItemsTitleMouseClicked(evt);
            }
        });
        GroupLayout recentItemsPanelLayout = new GroupLayout(recentItemsPanel);
        recentItemsPanel.setLayout(recentItemsPanelLayout);
        recentItemsPanelLayout.setHorizontalGroup(recentItemsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(recentItemsPanelLayout.createSequentialGroup().addGroup(recentItemsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(recentItemsPanelLayout.createSequentialGroup().addGap(97, 97, 97).addComponent(recentFileBtn)).addGroup(recentItemsPanelLayout.createSequentialGroup().addContainerGap().addComponent(jScrollPane1, -2, 136, -2))).addContainerGap(-1, Short.MAX_VALUE)).addComponent(recentItemsTitle, -1, -1, Short.MAX_VALUE));
        recentItemsPanelLayout.setVerticalGroup(recentItemsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(recentItemsPanelLayout.createSequentialGroup().addComponent(recentItemsTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jScrollPane1, -1, 357, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(recentFileBtn).addContainerGap()));
        appPanel.setOpaque(false);
        appPanel.setLayout(new GridBagLayout());
        GroupLayout mainPaneLayout = new GroupLayout(mainPane);
        mainPane.setLayout(mainPaneLayout);
        mainPaneLayout.setHorizontalGroup(mainPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, mainPaneLayout.createSequentialGroup().addContainerGap().addComponent(appPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(recentItemsPanel, -1, -1, -2).addComponent(jLabel2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        mainPaneLayout.setVerticalGroup(mainPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPaneLayout.createSequentialGroup().addContainerGap().addGroup(mainPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(appPanel, -1, -1, Short.MAX_VALUE).addGroup(mainPaneLayout.createSequentialGroup().addComponent(recentItemsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 84, Short.MAX_VALUE).addComponent(jLabel2))).addContainerGap()));
        mainPane.setLayer(jLabel2, JLayeredPane.DEFAULT_LAYER);
        mainPane.setLayer(recentItemsPanel, JLayeredPane.DEFAULT_LAYER);
        mainPane.setLayer(appPanel, JLayeredPane.DEFAULT_LAYER);
        this.getContentPane().add((Component)mainPane, "Center");
        this.pack();
    }

    private void formComponentShown(ComponentEvent evt) {
        this.setLocationRelativeTo(null);
    }

    private void recentFileBtnActionPerformed(ActionEvent evt) {
        if (recentFileList.getSelectedValue() == null) {
            return;
        }
        KeyValListItem file = (KeyValListItem)recentFileList.getSelectedValue();
        if (file.isEmpty()) {
            return;
        }
        Editor edit = new Editor();
        Debug.println(file.getValue());
        edit.openFileFromName(file.getValue());
        Main.loadFrame(edit);
    }

    private void recentFileListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.recentFileBtnActionPerformed(null);
        }
    }

    private void recentFileListMouseMoved(MouseEvent evt) {
        try {
            ListModel m = recentFileList.getModel();
            int index = recentFileList.locationToIndex(evt.getPoint());
            if (index > -1) {
                recentFileList.setToolTipText(((KeyValListItem)m.getElementAt(index)).getValue());
            }
        }
        catch (Exception ex) {
            recentFileList.setToolTipText("");
        }
    }

    private void recentItemsTitleMouseClicked(MouseEvent evt) {
    }

    public static void loadFrame(JInternalFrame frame, boolean show) {
        int w = frame.getWidth();
        int h = frame.getHeight();
        int pw = mainPane.getWidth();
        int ph = mainPane.getHeight();
        if (frame.isResizable()) {
            if (h > ph) {
                h = ph;
            }
            if (w > pw) {
                w = pw;
            }
            frame.setSize(w, h);
        }
        mainPane.add(frame);
        frame.setLocation(pw / 2 - w / 2, ph / 2 - h / 2);
        if (frame.getLocation().y < 0) {
            frame.setLocation(frame.getLocation().x, 0);
        }
        if (show) {
            frame.setVisible(true);
        }
    }

    public static void loadFrame(JInternalFrame frame) {
        Main.loadFrame(frame, true);
    }

    public static void cascade() {
        JInternalFrame[] frames = mainPane.getAllFrames();
        int x = 12;
        int y = 24;
        Debug.println("Cascading " + frames.length + " frames...");
        for (int i = 0; i < frames.length; ++i) {
            if (!frames[i].isVisible()) continue;
            Debug.println("Frame: " + frames[i].getTitle() + ", Times: " + i + ", Xpos: " + x * i + ", Ypos: " + y * i);
            frames[i].setBounds(x * i, y * i, frames[i].getWidth(), frames[i].getHeight());
            frames[i].toFront();
        }
    }

    public static void main(String[] args) {
        String[] sizes;
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, e);
        }
        try {
            ubuntuRegular = Font.createFont(0, Main.class.getResourceAsStream("/Ubuntu-R.ttf"));
        }
        catch (FontFormatException | IOException ex) {
            ubuntuRegular = Font.getFont("SansSerif");
            System.err.println("Error loading fonts: " + ex.getMessage());
        }
        catch (Exception ex) {
            ubuntuRegular = Font.getFont("SansSerif");
            System.err.println("Error loading fonts: " + ex.getMessage());
        }
        for (String s : sizes = new String[]{"16", "24", "32", "48", "64", "96", "128", "256", "512"}) {
            symatlogo.add(new ImageIcon(Main.class.getResource(s + "x" + s + ".png")).getImage());
        }
        String[] stringArray = args;
        int n = stringArray.length;
        block21: for (int i = 0; i < n; ++i) {
            String arg;
            switch (arg = stringArray[i]) {
                case "skippython": {
                    skipPython = true;
                    continue block21;
                }
                case "skipeditor": {
                    skipEditor = true;
                    continue block21;
                }
                case "quickstart": {
                    skipPython = true;
                    skipEditor = true;
                    continue block21;
                }
                case "licensereset": {
                    PrefStorage.saveSetting("license", "");
                    continue block21;
                }
                default: {
                    argfile = arg;
                }
            }
        }
        SingleInstanceClient sicli = new SingleInstanceClient(argfile);
        try {
            new SingleInstanceServer().start();
        }
        catch (IOException ex) {
            Debug.printerr("Cannot start instance listener:\n\n");
            Debug.stacktrace(ex);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new JFXPanel();
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Platform.setImplicitExit((boolean)false);
                    }
                });
            }
        });
        EventQueue.invokeLater(() -> new SplashScreen().setVisible(true));
    }

    static {
        skipPython = false;
        skipEditor = false;
        recentItemsMinimized = false;
        updateAvailable = false;
        updateString = "";
        licValid = false;
        symatlogo = new ArrayList();
        shellbtn = new JCommandButton("Shell", Main.getRibbonIcon("shell"));
        editorbtn = new JCommandButton("Editor", Main.getRibbonIcon("editor"));
        graphbtn = new JCommandButton("Graph", Main.getRibbonIcon("graph"));
        notepadbtn = new JCommandButton("Notepad", Main.getRibbonIcon("notepad"));
        wikibtn = new JCommandButton("Wiki", Main.getRibbonIcon("wiki"));
        browserbtn = new JCommandButton("Browser", Main.getRibbonIcon("browser"));
        padsbtn = new JCommandButton("Pads", Main.getRibbonIcon("pads"));
        tasksbtn = new JCommandButton("Tasks", Main.getRibbonIcon("tasks"));
        installpluginbtn = new JCommandButton("Install", Main.getRibbonIcon("installplugin"));
    }
}

