/*
 * Decompiled with CFR 0.152.
 */
package net.apocalypselabs.symat;

import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import net.apocalypselabs.symat.Debug;
import net.apocalypselabs.symat.Main;
import net.apocalypselabs.symat.PrefStorage;

public class License
extends JInternalFrame {
    private JButton contBtn;
    private JTextField emailBox;
    private JLabel emailLbl;
    private JButton exitBtn;
    private ButtonGroup grp1;
    private JLabel jLabel1;
    private JRadioButton noLicSel;
    private JRadioButton orgLicSel;
    private JRadioButton singLicSel;

    public License() {
        this.initComponents();
    }

    private void initComponents() {
        this.grp1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.singLicSel = new JRadioButton();
        this.orgLicSel = new JRadioButton();
        this.noLicSel = new JRadioButton();
        this.emailBox = new JTextField();
        this.emailLbl = new JLabel();
        this.contBtn = new JButton();
        this.exitBtn = new JButton();
        this.setTitle("Welcome");
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/net/apocalypselabs/symat/icon16.png")));
        this.setMaximumSize(new Dimension(435, 367));
        this.setMinimumSize(new Dimension(435, 367));
        this.setPreferredSize(new Dimension(435, 367));
        try {
            this.setSelected(true);
        }
        catch (PropertyVetoException e1) {
            e1.printStackTrace();
        }
        this.jLabel1.setText("<html>\n<h1>Welcome to SyMAT!</h1>\n<p>Please activate the software.  \n<br />Until you do, features will be limited.\n<br />You may be eligible for a free 15-day trial.</p>\n<br />\n<p>Do you have a license?</p>");
        this.grp1.add(this.singLicSel);
        this.singLicSel.setText("Yes, I have a single-user license");
        this.singLicSel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                License.this.singLicSelActionPerformed(evt);
            }
        });
        this.grp1.add(this.orgLicSel);
        this.orgLicSel.setText("No, but my school or work might have one");
        this.orgLicSel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                License.this.orgLicSelActionPerformed(evt);
            }
        });
        this.grp1.add(this.noLicSel);
        this.noLicSel.setSelected(true);
        this.noLicSel.setText("No, I don't have a license");
        this.noLicSel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                License.this.noLicSelActionPerformed(evt);
            }
        });
        this.emailBox.setCursor(new Cursor(2));
        this.emailBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                License.this.emailBoxActionPerformed(evt);
            }
        });
        this.emailBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                License.this.emailBoxKeyPressed(evt);
            }
        });
        this.emailLbl.setText("Great!  Enter your email address and we'll get things set up.");
        this.contBtn.setText("Continue");
        this.contBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                License.this.contBtnActionPerformed(evt);
            }
        });
        this.exitBtn.setText("Exit");
        this.exitBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                License.this.exitBtnActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.emailBox, -2, 267, -2).addComponent(this.noLicSel).addComponent(this.orgLicSel).addComponent(this.singLicSel).addComponent(this.jLabel1, -2, -1, -2).addComponent(this.emailLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 28, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.contBtn, -1, -1, Short.MAX_VALUE).addComponent(this.exitBtn, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.singLicSel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.orgLicSel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.noLicSel).addGap(17, 17, 17).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.emailLbl).addComponent(this.exitBtn)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.emailBox, -2, -1, -2).addComponent(this.contBtn)).addGap(40, 40, 40)));
        this.emailBox.setVisible(false);
        this.emailLbl.setVisible(false);
        this.pack();
    }

    private void singLicSelActionPerformed(ActionEvent evt) {
        this.emailLbl.setVisible(true);
        this.emailBox.setVisible(true);
        this.emailLbl.setText("Great!  Now just enter your email address.");
    }

    private void orgLicSelActionPerformed(ActionEvent evt) {
        this.emailLbl.setVisible(true);
        this.emailBox.setVisible(true);
        this.emailLbl.setText("OK, enter your school or work email address.");
    }

    private void noLicSelActionPerformed(ActionEvent evt) {
        this.emailLbl.setVisible(false);
        this.emailBox.setVisible(false);
    }

    private void openShop() {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(new URI("http://apis.symatapp.com/shoplink.php"));
            }
            catch (IOException | URISyntaxException ex) {
                JOptionPane.showInternalMessageDialog(this, "Please go to symatapp.com to purchase a license.");
            }
        } else {
            JOptionPane.showInternalMessageDialog(this, "Please go to symatapp.com to purchase a license.");
        }
    }

    private void contBtnActionPerformed(ActionEvent evt) {
        if (this.noLicSel.isSelected()) {
            if (PrefStorage.getSetting("licensetype").equals("demo") && PrefStorage.getSetting("licensedemo").equals("used")) {
                int ans = JOptionPane.showInternalConfirmDialog(this, "You have already used a trial license.\nWould you like to go online to get a license?", "Expired", 0);
                if (ans != 1) {
                    this.openShop();
                }
            } else {
                int ans = JOptionPane.showInternalConfirmDialog(this, "Would you like to go online and get a license?\nSelect no to activate a 15-day trial.", "Get License", 0);
                if (ans == 1) {
                    Calendar c = Calendar.getInstance();
                    c.setTime(new Date());
                    c.add(5, 15);
                    PrefStorage.saveSetting("licensetype", "demo");
                    PrefStorage.saveSetting("license", String.valueOf(c.getTimeInMillis()));
                    PrefStorage.saveSetting("licensedemo", "used");
                    JOptionPane.showInternalMessageDialog(this, "A trial license of 15 days has been activated.", "Activated", 1);
                    this.exit();
                } else {
                    this.openShop();
                }
            }
        } else if (this.checkRegex()) {
            new CheckThread(this.emailBox.getText()).start();
        }
    }

    private void emailBoxActionPerformed(ActionEvent evt) {
        this.checkRegex();
    }

    private void emailBoxKeyPressed(KeyEvent evt) {
        this.checkRegex();
    }

    private void exitBtnActionPerformed(ActionEvent evt) {
        int result = JOptionPane.showInternalConfirmDialog(this, "Are you sure you want to exit SyMAT?", "Quit", 0);
        if (result == 0) {
            System.exit(0);
        }
    }

    private boolean checkRegex() {
        if (License.checkEmail(this.emailBox.getText())) {
            this.contBtn.setEnabled(true);
            return true;
        }
        this.contBtn.setEnabled(false);
        return false;
    }

    public static boolean checkEmail(String email) {
        String regex = "^[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]+$";
        return email.matches(regex);
    }

    public void exit() {
        this.dispose();
    }

    private class CheckThread
    extends Thread {
        private final String email;

        public CheckThread(String useremail) {
            this.email = useremail;
        }

        @Override
        public void run() {
            try {
                String line;
                System.out.println("Checking license...");
                URL url = new URL("http://apis.symatapp.com/liccheck.php?email=" + this.email);
                try (InputStream is = url.openStream();
                     BufferedReader br = new BufferedReader(new InputStreamReader(is));){
                    line = br.readLine();
                }
                switch (line) {
                    case "ok:single": {
                        this.success("single");
                        break;
                    }
                    case "ok:domain": {
                        this.success("domain");
                        break;
                    }
                    case "checkemail": {
                        this.email();
                        break;
                    }
                    default: {
                        this.fail();
                        break;
                    }
                }
            }
            catch (Exception e) {
                Debug.printerr("License check failed.");
                Debug.stacktrace(e);
                this.ioerror();
            }
        }

        private void success(String type) {
            PrefStorage.saveSetting("license", this.email);
            PrefStorage.saveSetting("licensetype", type);
            JOptionPane.showInternalMessageDialog(Main.mainPane, "Thank you for activating SyMAT!", "Success", 1);
            Main.licenseRestrict(false);
            License.this.exit();
        }

        private void fail() {
            JOptionPane.showInternalMessageDialog(Main.mainPane, "There is not a valid license for that email address.", "Activation failure", 0);
        }

        private void email() {
            try {
                String line;
                String code = JOptionPane.showInternalInputDialog(Main.mainPane, "A code has been emailed to you.  Enter it below to verify.", "Almost done!", 3);
                Debug.println("Checking license code (" + code + ")...");
                URL url = new URL("http://apis.symatapp.com/emailverify.php?code=" + code + "&email=" + this.email);
                try (InputStream is = url.openStream();){
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    line = br.readLine();
                    br.close();
                }
                if (code.equals(line)) {
                    this.success("domain");
                } else {
                    JOptionPane.showInternalMessageDialog(Main.mainPane, "Code invalid.", "Error", 0);
                }
            }
            catch (IOException ex) {
                this.ioerror();
            }
        }

        private void ioerror() {
            JOptionPane.showMessageDialog(Main.mainPane, "An error occured while verifying your license.  Ensure you have an Internet connection and try again later.  If the problem persists, contact Netsyms Technologies Licensing at software@netsyms.com.", "Error", 0);
        }
    }
}

