/*
 * Decompiled with CFR 0.152.
 */
package net.apocalypselabs.symat;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.DefaultCaret;
import net.apocalypselabs.symat.CodeCompleter;
import net.apocalypselabs.symat.CodeRunner;
import net.apocalypselabs.symat.FileUtils;
import net.apocalypselabs.symat.Main;
import net.apocalypselabs.symat.PrefStorage;
import net.apocalypselabs.symat.Theme;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.CompletionProvider;

public class Interpreter
extends JInternalFrame {
    private final CodeRunner cr;
    private String[] history = new String[10];
    private String commandsForExport = "";
    private int historyIndex = 0;
    private String lang = "javascript";
    private Object ans = 0;
    private CompletionProvider jscomp = new CodeCompleter("js").getProvider();
    private CompletionProvider pycomp = new CodeCompleter("py").getProvider();
    private CompletionProvider javacomp = new CodeCompleter("java").getProvider();
    private AutoCompletion jsac = new AutoCompletion(this.jscomp);
    private AutoCompletion pyac = new AutoCompletion(this.pycomp);
    private AutoCompletion javaac = new AutoCompletion(this.javacomp);
    private Interpreter thisobject = this;
    private String cursorStr = ">>";
    private JMenuItem clearBtn;
    private JMenuItem exportHistoryBtn;
    private JTextField inputBox;
    private JLabel jLabel1;
    private JMenu jMenu1;
    private JMenu jMenu3;
    private JMenu jMenu4;
    private JMenuBar jMenuBar1;
    private JScrollPane jScrollPane1;
    private JRadioButtonMenuItem javaMenu;
    private JRadioButtonMenuItem javascriptMenu;
    private ButtonGroup langGroup;
    private JMenu langMenu;
    private JTextArea mainBox;
    private JRadioButtonMenuItem pythonMenu;
    private JButton runBtn;
    private JMenuItem setDefaultLang;

    public Interpreter(String useLang) {
        this.initComponents();
        this.lang = useLang;
        if (this.lang.equals("default")) {
            this.lang = PrefStorage.getSetting("shellLang", "javascript");
        }
        this.jLabel1.setText(" >>");
        this.cursorStr = (PrefStorage.getSetting("shellcursor", "").equals("") ? "" : (this.lang.startsWith("j") ? "js" : "py")) + ">>";
        this.cr = new CodeRunner(this.lang);
        if (this.lang.equals("python")) {
            this.javascriptMenu.setSelected(false);
            this.pythonMenu.setSelected(true);
            this.javaMenu.setSelected(false);
            this.pyac.install(this.inputBox);
            this.setTitle("Shell [python]");
        } else if (this.lang.equals("java")) {
            this.setTitle("Shell [java]");
            this.javascriptMenu.setSelected(false);
            this.pythonMenu.setSelected(false);
            this.javaMenu.setSelected(true);
            this.javaac.install(this.inputBox);
        } else {
            this.jsac.install(this.inputBox);
            this.setTitle("Shell [javascript]");
        }
        int font_size = 12;
        try {
            font_size = Integer.valueOf(PrefStorage.getSetting("editfont", "12"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mainBox.setFont(new Font("Monospaced", 0, font_size));
        this.inputBox.setFont(new Font("Monospaced", 0, font_size));
        this.loadTheme();
        this.mainBox.setText(this.cursorStr);
        this.inputBox.requestFocus();
    }

    public Interpreter() {
        this("default");
    }

    private void initComponents() {
        this.langGroup = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.mainBox = new JTextArea();
        this.inputBox = new JTextField();
        this.runBtn = new JButton();
        this.jLabel1 = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu3 = new JMenu();
        this.exportHistoryBtn = new JMenuItem();
        this.jMenu4 = new JMenu();
        this.clearBtn = new JMenuItem();
        this.langMenu = new JMenu();
        this.jMenu1 = new JMenu();
        this.javascriptMenu = new JRadioButtonMenuItem();
        this.pythonMenu = new JRadioButtonMenuItem();
        this.javaMenu = new JRadioButtonMenuItem();
        this.setDefaultLang = new JMenuItem();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Shell");
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/net/apocalypselabs/symat/icons/shell.png")));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Interpreter.this.formMouseClicked(evt);
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                Interpreter.this.formFocusGained(evt);
            }
        });
        this.mainBox.setEditable(false);
        this.mainBox.setColumns(20);
        this.mainBox.setFont(new Font("Courier New", 0, 15));
        this.mainBox.setLineWrap(true);
        this.mainBox.setRows(2);
        this.mainBox.setTabSize(4);
        this.mainBox.setWrapStyleWord(true);
        DefaultCaret caret = (DefaultCaret)this.mainBox.getCaret();
        caret.setUpdatePolicy(2);
        this.mainBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Interpreter.this.mainBoxMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.mainBox);
        this.inputBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Interpreter.this.inputBoxMouseClicked(evt);
            }
        });
        this.inputBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                Interpreter.this.inputBoxKeyPressed(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                Interpreter.this.inputBoxKeyTyped(evt);
            }
        });
        this.runBtn.setText("Run");
        this.runBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Interpreter.this.runBtnMouseClicked(evt);
            }
        });
        this.runBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Interpreter.this.runBtnActionPerformed(evt);
            }
        });
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText(">>");
        this.jMenu3.setText("File");
        this.exportHistoryBtn.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.exportHistoryBtn.setText("Save history...");
        this.exportHistoryBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Interpreter.this.exportHistoryBtnActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.exportHistoryBtn);
        this.jMenuBar1.add(this.jMenu3);
        this.jMenu4.setText("Edit");
        this.clearBtn.setText("Clear window");
        this.clearBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Interpreter.this.clearBtnActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.clearBtn);
        this.jMenuBar1.add(this.jMenu4);
        this.langMenu.setText("Language");
        this.jMenu1.setText("Switch");
        this.langGroup.add(this.javascriptMenu);
        this.javascriptMenu.setSelected(true);
        this.javascriptMenu.setText("JavaScript");
        this.javascriptMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Interpreter.this.javascriptMenuActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.javascriptMenu);
        this.langGroup.add(this.pythonMenu);
        this.pythonMenu.setText("Python");
        this.pythonMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Interpreter.this.pythonMenuActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.pythonMenu);
        this.langGroup.add(this.javaMenu);
        this.javaMenu.setText("Java");
        this.javaMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Interpreter.this.javaMenuActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.javaMenu);
        this.langMenu.add(this.jMenu1);
        this.setDefaultLang.setText("Set as default");
        this.setDefaultLang.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Interpreter.this.setDefaultLangActionPerformed(evt);
            }
        });
        this.langMenu.add(this.setDefaultLang);
        this.jMenuBar1.add(this.langMenu);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 422, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inputBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.runBtn)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 245, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.inputBox, GroupLayout.Alignment.LEADING).addComponent(this.runBtn, -2, 0, Short.MAX_VALUE)).addGap(2, 2, 2)));
        this.pack();
    }

    private void runBtnActionPerformed(ActionEvent evt) {
        this.doRunCode();
    }

    private void loadTheme() {
        this.mainBox.setBackground(Theme.boxColor());
        this.mainBox.setForeground(Theme.textColor());
        this.inputBox.setBackground(Theme.boxColor());
        this.inputBox.setForeground(Theme.textColor());
        this.setBackground(Theme.windowColor());
    }

    private void inputBoxKeyTyped(KeyEvent evt) {
        if (evt.getKeyChar() == '\n') {
            this.doRunCode();
        }
    }

    private void inputBoxKeyPressed(KeyEvent evt) {
        switch (evt.getKeyCode()) {
            case 38: {
                if (this.historyIndex >= 9) break;
                if (this.historyIndex < 0) {
                    ++this.historyIndex;
                }
                this.inputBox.setText(this.history[this.historyIndex]);
                ++this.historyIndex;
                break;
            }
            case 40: {
                if (this.historyIndex < 0) break;
                --this.historyIndex;
                if (this.historyIndex < 0) {
                    this.historyIndex = 0;
                    this.inputBox.setText("");
                    break;
                }
                this.inputBox.setText(this.history[this.historyIndex]);
            }
        }
    }

    private void setDefaultLangActionPerformed(ActionEvent evt) {
        String pref = "javascript";
        if (this.pythonMenu.isSelected()) {
            pref = "python";
        } else if (this.javaMenu.isSelected()) {
            pref = "java";
        }
        PrefStorage.saveSetting("shellLang", pref);
        PrefStorage.save();
    }

    private void javascriptMenuActionPerformed(ActionEvent evt) {
        if (!this.lang.equals("javascript")) {
            Main.loadFrame(new Interpreter("javascript"));
            this.dispose();
        }
    }

    private void pythonMenuActionPerformed(ActionEvent evt) {
        if (!this.lang.equals("python")) {
            Main.loadFrame(new Interpreter("python"));
            this.dispose();
        }
    }

    private void formMouseClicked(MouseEvent evt) {
        this.loadTheme();
    }

    private void mainBoxMouseClicked(MouseEvent evt) {
        this.formMouseClicked(evt);
    }

    private void inputBoxMouseClicked(MouseEvent evt) {
        this.formMouseClicked(evt);
    }

    private void runBtnMouseClicked(MouseEvent evt) {
        this.formMouseClicked(evt);
    }

    private void exportHistoryBtnActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        FileNameExtensionFilter filter = this.javascriptMenu.isSelected() ? new FileNameExtensionFilter("SyMAT JavaScript (.syjs)", "syjs") : (this.javaMenu.isSelected() ? new FileNameExtensionFilter("SyMAT Java (.syjava)", "syjava") : new FileNameExtensionFilter("SyMAT Python (.sypy)", "sypy"));
        fc.setFileFilter(filter);
        fc.addChoosableFileFilter(filter);
        int result = fc.showSaveDialog(this);
        if (result == 0) {
            try {
                FileUtils.saveFile(this.commandsForExport, FileUtils.getFileWithExtension(fc).toString(), true);
            }
            catch (IOException ex) {
                JOptionPane.showInternalMessageDialog(this, "Error saving: " + ex.getMessage(), "Error", 0);
            }
        }
    }

    private void clearBtnActionPerformed(ActionEvent evt) {
        this.mainBox.setText(this.cursorStr);
        this.commandsForExport = "";
    }

    private void formFocusGained(FocusEvent evt) {
        this.inputBox.requestFocusInWindow();
    }

    private void javaMenuActionPerformed(ActionEvent evt) {
        if (!this.lang.equals("java")) {
            Main.loadFrame(new Interpreter("java"));
            this.dispose();
        }
    }

    private void doRunCode() {
        String code = this.inputBox.getText();
        this.commandsForExport = this.commandsForExport + code + "\n";
        this.mainBox.append(" " + code + "\n");
        this.runBtn.setEnabled(false);
        this.inputBox.setEnabled(false);
        new EvalThread(code).start();
    }

    private class EvalThread
    extends Thread {
        private String code = "";

        public EvalThread(String cmd) {
            this.code = cmd;
        }

        private boolean doSpecialCommands() {
            String ansfill;
            switch (this.code) {
                case "clc": 
                case "clear": {
                    this.clrOutput();
                    return false;
                }
                case "exit": {
                    Interpreter.this.thisobject.dispose();
                }
            }
            try {
                ansfill = String.valueOf(Double.parseDouble(Interpreter.this.ans.toString()));
            }
            catch (NumberFormatException ex) {
                ansfill = "\"" + Interpreter.this.ans.toString() + "\"";
            }
            this.code = this.code.replace("ans", ansfill);
            return true;
        }

        @Override
        public void run() {
            try {
                if (this.doSpecialCommands()) {
                    Object result = Interpreter.this.cr.evalString(this.code);
                    if (result != null && !result.toString().trim().equals("")) {
                        Interpreter.this.ans = result;
                    }
                    this.append(result.toString() + "\n");
                }
            }
            catch (NullPointerException result) {
                // empty catch block
            }
            this.append(Interpreter.this.cursorStr);
            for (int i = 9; i > 0; --i) {
                ((Interpreter)Interpreter.this).history[i] = Interpreter.this.history[i - 1];
            }
            ((Interpreter)Interpreter.this).history[0] = this.code;
            this.clrInput();
            Interpreter.this.historyIndex = -1;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Interpreter.this.inputBox.setEnabled(true);
                    Interpreter.this.runBtn.setEnabled(true);
                    Interpreter.this.inputBox.requestFocusInWindow();
                }
            });
        }

        private void clrInput() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Interpreter.this.inputBox.setText("");
                }
            });
        }

        private void clrOutput() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Interpreter.this.mainBox.setText("");
                    Interpreter.this.commandsForExport = "";
                }
            });
        }

        private void append(String out) {
            final String output = out;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Interpreter.this.mainBox.append(output);
                    Interpreter.this.mainBox.setCaretPosition(Interpreter.this.mainBox.getText().length());
                }
            });
        }
    }
}

