/*
 * Decompiled with CFR 0.152.
 */
package net.apocalypselabs.symat;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.apocalypselabs.symat.Debug;
import net.apocalypselabs.symat.Main;
import net.apocalypselabs.symat.plugin.LoadPlugin;
import net.apocalypselabs.symat.plugin.Plugin;
import org.python.google.common.io.Files;

public class InstallPlugin
extends JInternalFrame {
    private final JFileChooser fc = new JFileChooser();
    private File f = null;
    private JTextField author;
    private JLabel iconBox;
    private JButton installBtn;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JScrollPane jScrollPane1;
    private JTextArea longDesc;
    private JButton openPluginBtn;
    private JTextField pluginName;
    private JTextField shortDesc;
    private JTextField version;
    private JTextField website;

    public InstallPlugin() {
        this.fc.setFileFilter(new FileNameExtensionFilter("Plugin (sypl)", "sypl"));
        this.initComponents();
    }

    public InstallPlugin(File f) {
        this();
        this.openPlugin(f);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.pluginName = new JTextField();
        this.jLabel4 = new JLabel();
        this.author = new JTextField();
        this.jLabel3 = new JLabel();
        this.website = new JTextField();
        this.version = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.shortDesc = new JTextField();
        this.jLabel7 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.longDesc = new JTextArea();
        this.openPluginBtn = new JButton();
        this.iconBox = new JLabel();
        this.installBtn = new JButton();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setTitle("Install Plugin");
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/net/apocalypselabs/symat/icons/plugins.png")));
        this.jLabel1.setText("Plugin Name:");
        this.pluginName.setEditable(false);
        this.jLabel4.setText("Author:");
        this.author.setEditable(false);
        this.jLabel3.setText("Website:");
        this.website.setEditable(false);
        this.version.setEditable(false);
        this.jLabel5.setText("Version:");
        this.jLabel6.setText("Description:");
        this.shortDesc.setEditable(false);
        this.jLabel7.setText("Long Description:");
        this.longDesc.setEditable(false);
        this.longDesc.setColumns(20);
        this.longDesc.setRows(5);
        this.jScrollPane1.setViewportView(this.longDesc);
        this.openPluginBtn.setText("Open Plugin");
        this.openPluginBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstallPlugin.this.openPluginBtnActionPerformed(evt);
            }
        });
        this.iconBox.setHorizontalAlignment(0);
        this.installBtn.setText("Install Plugin");
        this.installBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstallPlugin.this.installBtnActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(layout.createSequentialGroup().addComponent(this.openPluginBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.iconBox, -2, 104, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.installBtn)).addComponent(this.jScrollPane1)).addComponent(this.jLabel7).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel6, -2, 72, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.website).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.version)).addGroup(layout.createSequentialGroup().addComponent(this.pluginName).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel4, -2, 39, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.author)).addComponent(this.shortDesc, -2, 317, -2))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.openPluginBtn, -2, 32, -2).addComponent(this.iconBox, -2, 80, -2).addComponent(this.installBtn, -2, 32, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.pluginName, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.author, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.website, -2, -1, -2).addComponent(this.jLabel5).addComponent(this.version, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.shortDesc, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 150, -2)));
        this.pack();
    }

    private void openPluginBtnActionPerformed(ActionEvent evt) {
        int result = this.fc.showDialog(this, "Open Plugin");
        if (result == 0) {
            this.openPlugin(this.fc.getSelectedFile());
        }
    }

    private void openPlugin(File file) {
        try {
            Plugin p = new LoadPlugin(file).getPlugin();
            this.pluginName.setText(p.getTitle());
            this.shortDesc.setText(p.getLongTitle());
            this.version.setText(p.getVersion());
            this.longDesc.setText(p.getDesc());
            this.website.setText(p.getWebsite());
            this.author.setText(p.getAuthor());
            this.iconBox.setIcon(p.getIcon());
            this.f = file;
        }
        catch (Exception ex) {
            Debug.stacktrace(ex);
            JOptionPane.showInternalMessageDialog(this, "Error opening plugin.\n\n" + ex.getMessage());
        }
    }

    private void installBtnActionPerformed(ActionEvent evt) {
        if (this.f == null) {
            return;
        }
        try {
            String fsep = System.getProperty("file.separator");
            Files.copy((File)this.f, (File)new File(System.getProperty("user.home") + fsep + ".symat" + fsep + "plugins" + fsep + this.f.getName()));
            Main.maingui.reloadRibbon();
            JOptionPane.showInternalMessageDialog(this, "Plugin installed!", "Success", -1);
        }
        catch (IOException ex) {
            Debug.stacktrace(ex);
            JOptionPane.showInternalMessageDialog(this, "Error: could not install plugin file: " + ex.getMessage(), "Error", 0);
        }
        catch (IllegalArgumentException ex) {
            Debug.stacktrace(ex);
            JOptionPane.showInternalMessageDialog(this, "Error: could not install plugin file.\nIs a plugin with the same name already installed?\n(" + ex.getMessage() + ")", "Error", 0);
        }
        catch (Exception ex) {
            Debug.stacktrace(ex);
            JOptionPane.showInternalMessageDialog(this, "Error: could not install plugin file.Try restarting SyMAT.\n" + ex.getMessage(), "Error", 0);
        }
    }
}

