/*
 * Decompiled with CFR 0.152.
 */
package net.apocalypselabs.symat;

import java.awt.Color;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Calendar;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import net.apocalypselabs.symat.CodeRunner;
import net.apocalypselabs.symat.PrefStorage;

public class Help
extends JInternalFrame {
    private final HTMLEditorKit kit;
    private final StyleSheet styleSheet;
    private final StyleSheet dark = new StyleSheet();
    private final StyleSheet light = new StyleSheet();
    private int styleloaded = -1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JEditorPane topicBrowser;
    private JList topicList;

    public Help() {
        this.kit = new HTMLEditorKit();
        this.initComponents();
        this.styleSheet = this.kit.getStyleSheet();
        this.loadStyleSheets();
        this.loadTheme();
    }

    private void loadStyleSheets() {
        this.dark.addRule("body { background-color: #293134; }");
        this.dark.addRule("h1 { color: #ffffff; }");
        this.dark.addRule("h2 { color: #ffffff; }");
        this.dark.addRule("p { color: #ffffff; }");
        this.light.addRule("body { background-color: #ffffff; }");
        this.light.addRule("h1 { color: #000000; }");
        this.light.addRule("h2 { color: #000000; }");
        this.light.addRule("p { color: #000000; }");
    }

    private void loadTheme() {
        if (PrefStorage.getSetting("theme").equals("dark") && this.styleloaded == 0 || !PrefStorage.getSetting("theme").equals("dark") && this.styleloaded == 1) {
            this.styleloaded = -1;
        }
        if (this.styleloaded == -1) {
            if (PrefStorage.getSetting("theme").equals("dark")) {
                this.topicList.setBackground(new Color(41, 49, 52));
                this.topicList.setForeground(Color.WHITE);
                this.styleSheet.addStyleSheet(this.dark);
                this.styleSheet.removeStyleSheet(this.light);
                this.setBackground(Color.DARK_GRAY);
                this.styleloaded = 1;
            } else {
                this.topicList.setBackground(Color.WHITE);
                this.topicList.setForeground(Color.BLACK);
                this.styleSheet.addStyleSheet(this.light);
                this.styleSheet.removeStyleSheet(this.dark);
                this.setBackground(Color.LIGHT_GRAY);
                this.styleloaded = 0;
            }
            try {
                this.loadTopic(this.topicList.getSelectedValue().toString().toLowerCase());
            }
            catch (Exception ex) {
                this.loadTopic("welcome");
            }
        }
    }

    public void loadTopic(String topicName) {
        new LoadThread(topicName).start();
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.topicList = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.topicBrowser = new JEditorPane();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Manual");
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/net/apocalypselabs/symat/icons/help.png")));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                Help.this.formComponentShown(evt);
            }
        });
        this.jSplitPane1.setDividerLocation(100);
        this.jSplitPane1.setDividerSize(3);
        this.jSplitPane1.setResizeWeight(0.1);
        this.topicList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Welcome", "Basics", "Editor", "Pads", "Graphing", "Notepad", "Tasks", "Commands", "Licenses"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.topicList.setSelectionMode(0);
        this.topicList.setSelectedIndex(0);
        this.topicList.setVisibleRowCount(9);
        this.topicList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Help.this.topicListMouseClicked(evt);
            }
        });
        this.topicList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                Help.this.topicListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.topicList);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.topicBrowser.setEditable(false);
        this.topicBrowser.setBorder(null);
        this.topicBrowser.setContentType("text/html");
        this.topicBrowser.setText("<html>\r\n  <head>\r\n\r\n  </head>\r\n  <body>\r\n    <p style=\"margin-top: 0\">\r\n      \rHi there\n    </p>\r\n  </body>\r\n</html>\r\n");
        this.topicBrowser.setEditorKit(this.kit);
        this.topicBrowser.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Help.this.topicBrowserMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.topicBrowser);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 394, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 278, Short.MAX_VALUE));
        this.pack();
    }

    private void topicListValueChanged(ListSelectionEvent evt) {
        this.loadTopic(this.topicList.getSelectedValue().toString().toLowerCase());
    }

    private void formComponentShown(ComponentEvent evt) {
        this.topicList.setSelectedIndex(0);
        this.loadTopic("welcome");
    }

    private void topicListMouseClicked(MouseEvent evt) {
        this.loadTheme();
    }

    private void topicBrowserMouseClicked(MouseEvent evt) {
        this.loadTheme();
    }

    private class LoadThread
    extends Thread {
        String name;

        public LoadThread(String topic) {
            this.name = topic;
        }

        @Override
        public void run() {
            this.setText("<p><i>Loading...</i></p>", "Manual");
            if (this.name.equals("welcome")) {
                String text = "<html><head><title>About SyMAT</title></head><body><h1>Welcome to SyMAT!</h1><p>SyMAT is a Java-based algebra and calculus system.  Scripts and commands can be written in JavaScript or Python.</p><p>This is SyMAT version 2.1 (24).</p><p>SyMAT is copyright &copy; " + Calendar.getInstance().get(1) + " Netsyms Technologies." + "<br />" + "This built-in documentation falls under the SyMAT Media License.</p>";
                this.setText(text, "Manual");
            } else {
                try {
                    String line;
                    String text = "";
                    BufferedReader reader = new BufferedReader(new InputStreamReader(CodeRunner.class.getResourceAsStream("help/" + this.name + ".html")));
                    while ((line = reader.readLine()) != null) {
                        text = text + line;
                    }
                    this.setText(text, "Manual (" + Help.this.topicList.getSelectedValue().toString() + ")");
                }
                catch (Exception e) {
                    this.setText("<html><head></head><body><p><b>Error:</b><br>Cannot get help topic \"" + this.name + "\".<br>(" + e.getMessage() + ")</p></body></html>", "Manual");
                }
            }
        }

        private void setText(String string, String wintitle) {
            final String text = string;
            final String title = wintitle;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Help.this.topicBrowser.setText(text);
                    Help.this.topicBrowser.setCaretPosition(0);
                    Help.this.setTitle(title);
                }
            });
        }
    }
}

