/*
 * Decompiled with CFR 0.152.
 */
package net.apocalypselabs.symat;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.apocalypselabs.symat.CodeRunner;
import net.apocalypselabs.symat.Debug;
import net.apocalypselabs.symat.Main;
import org.math.plot.Plot2DPanel;
import org.math.plot.plotObjects.BaseLabel;
import org.math.plot.plotObjects.Plotable;
import org.matheclipse.core.eval.EvalUtilities;

public class Graph
extends JInternalFrame {
    private final JFileChooser fc = new JFileChooser();
    private boolean standalone = true;
    private BaseLabel lbl = new BaseLabel("", Color.black, new double[]{0.5, 1.1});
    private String history = "";
    boolean graphing = false;
    private double xmin = -10.0;
    private double xmax = 10.0;
    private JMenuItem clrGraphBtn;
    private JMenuItem exportBtn;
    private JTextField inBox;
    private JLabel jLabel1;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenuBar jMenuBar1;
    private Plot2DPanel plot;
    private JButton plotBtn;
    private JMenuItem setTitleBtn;

    public Graph() {
        this.init();
    }

    public Graph(boolean isInternal) {
        this.init();
        this.standalone = !isInternal;
    }

    private void init() {
        this.initComponents();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("PNG image (.png)", "png");
        this.fc.setFileFilter(filter);
        this.fc.addChoosableFileFilter(filter);
        this.plot.plotToolBar.remove(5);
        this.plot.plotToolBar.remove(4);
        this.plot.plotToolBar.remove(3);
        this.lbl.setFont(new Font("Courier", 1, 18));
        this.plot.addPlotable((Plotable)this.lbl);
    }

    @Override
    public void doDefaultCloseAction() {
        if (this.standalone) {
            this.dispose();
        } else {
            this.hide();
        }
    }

    public void forceClose() {
        this.dispose();
    }

    private void initComponents() {
        this.inBox = new JTextField();
        this.jLabel1 = new JLabel();
        this.plotBtn = new JButton();
        this.plot = new Plot2DPanel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.exportBtn = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.clrGraphBtn = new JMenuItem();
        this.setTitleBtn = new JMenuItem();
        this.setClosable(true);
        this.setDefaultCloseOperation(1);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Graph");
        this.setToolTipText("");
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/net/apocalypselabs/symat/icons/graph.png")));
        this.setPreferredSize(new Dimension(326, 402));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                Graph.this.formComponentShown(evt);
            }
        });
        this.inBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                Graph.this.inBoxKeyTyped(evt);
            }
        });
        this.jLabel1.setText("f(x)=");
        this.plotBtn.setText(">>");
        this.plotBtn.setToolTipText("");
        this.plotBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Graph.this.plotBtnActionPerformed(evt);
            }
        });
        this.plot.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Graph.this.plotMouseClicked(evt);
            }
        });
        this.jMenu1.setText("File");
        this.exportBtn.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.exportBtn.setText("Export graph...");
        this.exportBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Graph.this.exportBtnActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.exportBtn);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Edit");
        this.clrGraphBtn.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.clrGraphBtn.setText("Clear Graph");
        this.clrGraphBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Graph.this.clrGraphBtnActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.clrGraphBtn);
        this.setTitleBtn.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.setTitleBtn.setText("Set Title...");
        this.setTitleBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Graph.this.setTitleBtnActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.setTitleBtn);
        this.jMenuBar1.add(this.jMenu2);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inBox, -1, 215, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.plotBtn).addGap(10, 10, 10)).addComponent((Component)this.plot, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent((Component)this.plot, -1, 311, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.inBox, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.plotBtn)).addContainerGap()));
        this.pack();
    }

    private void plotBtnActionPerformed(ActionEvent evt) {
        String[] frmlas;
        for (String f : frmlas = this.inBox.getText().split(";")) {
            new GraphThread(f).start();
        }
    }

    private void formComponentShown(ComponentEvent evt) {
    }

    public void plotPoints(double[] x, double[] y) {
        this.plotPoints(x, y, "Points");
    }

    public void plotPoints(double[] x, double[] y, String name) {
        this.plot.addLinePlot(name, x, y);
    }

    @Deprecated
    public static double getScale(int zoomLevel) {
        return 15.0;
    }

    public void drawDot(double x, double y) {
        double[] xpt = new double[]{x};
        double[] ypt = new double[]{y};
        this.plot.addScatterPlot("", Color.BLACK, xpt, ypt);
    }

    private void inBoxKeyTyped(KeyEvent evt) {
        if (evt.getKeyChar() == '\n') {
            this.plotBtn.doClick();
        }
    }

    private void clrGraphBtnActionPerformed(ActionEvent evt) {
        this.clearDraw();
    }

    private void exportBtnActionPerformed(ActionEvent evt) {
        int result = this.fc.showSaveDialog(Main.mainPane);
        if (result == 0) {
            File file = new File(this.addSaveExt(this.fc.getSelectedFile().toString()));
            try {
                this.plot.toGraphicFile(file);
            }
            catch (IOException ex) {
                JOptionPane.showInternalMessageDialog(this, "Image export failed!", "Error", 0);
            }
        }
    }

    private void setTitleBtnActionPerformed(ActionEvent evt) {
        String wintitle = JOptionPane.showInternalInputDialog(this, "New window title:", "Rename", 3);
        if (wintitle != null && !wintitle.equals("")) {
            this.setWindowTitle(wintitle);
            this.setLabel(wintitle);
        }
    }

    private void plotMouseClicked(MouseEvent evt) {
    }

    public double[] getRange() {
        double[] range = new double[]{this.xmin, this.xmax};
        return range;
    }

    public void setRange(double min, double max) {
        this.xmin = min;
        this.xmax = max;
        this.clearDraw(false);
        this.plot.setFixedBounds(0, min, max);
        if (!this.history.trim().equals("")) {
            String temp = "";
            for (String cmd : this.history.trim().split("\n")) {
                if ((cmd = cmd.trim()).equals("")) continue;
                temp = temp + cmd + "\n";
            }
            this.history = temp.trim();
            new GraphThread(this.history.split("\n")).start();
            this.inBox.setText("");
        }
    }

    public void graphFunction(String f) {
        this.inBox.setText(f);
        this.plotBtnActionPerformed(null);
    }

    public void setLabel(String label) {
        this.lbl.setText(label);
    }

    private String addSaveExt(String path) {
        if (!path.matches(".*\\.(png)")) {
            path = path + ".png";
        }
        return path;
    }

    public void setWindowTitle(String t) {
        this.setTitle(t);
    }

    public String getWindowTitle() {
        return this.getTitle();
    }

    public void clearDraw() {
        this.clearDraw(true);
    }

    public void clearDraw(boolean alsoHistory) {
        if (alsoHistory) {
            this.history = "";
        }
        this.plot.removeAllPlots();
    }

    private class GraphThread
    extends Thread {
        String[] frmlas;

        public GraphThread(String frmla) {
            this.frmlas = new String[1];
            this.frmlas[0] = frmla;
        }

        public GraphThread(String[] frmla) {
            this.frmlas = frmla;
        }

        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Graph.this.inBox.setEnabled(false);
                    Graph.this.plotBtn.setEnabled(false);
                    for (Component mu : Graph.this.jMenuBar1.getComponents()) {
                        mu.setEnabled(false);
                    }
                }
            });
            String[] stringArray = this.frmlas;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                int i2;
                String formula;
                String niceformula = formula = stringArray[i];
                CodeRunner cr = new CodeRunner();
                formula = formula.replaceAll("x", "\\$x");
                EvalUtilities solver = new EvalUtilities();
                String xx = "";
                String yy = "";
                for (double x = Graph.this.xmin; x <= Graph.this.xmax; x += (Graph.this.xmax - Graph.this.xmin) / 400.0) {
                    String res;
                    try {
                        cr.setVar("x", x);
                        res = solver.evaluate("$x=" + x + ";N[" + formula + "]").toString();
                    }
                    catch (Exception ex) {
                        res = "0";
                    }
                    try {
                        if (!(Double.parseDouble(res) > -2.147483648E9)) continue;
                        xx = xx + String.valueOf(x) + " ";
                        yy = yy + res + " ";
                        continue;
                    }
                    catch (Exception ex) {
                        xx = xx + String.valueOf(x) + " ";
                        yy = yy + res + " ";
                    }
                }
                Debug.println(xx);
                Debug.println(yy);
                String[] xs = xx.trim().split(" ");
                String[] ys = yy.trim().split(" ");
                double[] xd = new double[xs.length];
                double[] yd = new double[ys.length];
                for (i2 = 0; i2 < xs.length; ++i2) {
                    try {
                        xd[i2] = Double.parseDouble(xs[i2]);
                        continue;
                    }
                    catch (Exception ex) {
                        xd[i2] = 0.0;
                    }
                }
                for (i2 = 0; i2 < ys.length; ++i2) {
                    try {
                        yd[i2] = Double.parseDouble(ys[i2]);
                        continue;
                    }
                    catch (Exception ex) {
                        yd[i2] = 0.0;
                    }
                }
                SwingUtilities.invokeLater(new Updater(niceformula, xd, yd));
            }
            SwingUtilities.invokeLater(new Finisher());
        }

        private class Finisher
        implements Runnable {
            private Finisher() {
            }

            @Override
            public void run() {
                Graph.this.inBox.setEnabled(true);
                Graph.this.plotBtn.setEnabled(true);
                for (Component mu : Graph.this.jMenuBar1.getComponents()) {
                    mu.setEnabled(true);
                }
                Graph.this.inBox.requestFocusInWindow();
            }
        }

        private class Updater
        implements Runnable {
            final double[] xd;
            final double[] yd;
            final String formula;

            public Updater(String frmla, double[] x, double[] y) {
                this.xd = x;
                this.yd = y;
                this.formula = frmla;
            }

            @Override
            public void run() {
                Graph.this.plot.addLinePlot(this.formula, this.xd, this.yd);
                Graph.this.history = Graph.this.history + this.formula + "\n";
            }
        }
    }
}

