/*
 * Decompiled with CFR 0.152.
 */
package net.apocalypselabs.symat;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.apocalypselabs.symat.Debug;
import net.apocalypselabs.symat.Functions;
import org.mozilla.javascript.NativeArray;

public class Globals
extends JInternalFrame {
    private JButton addBtn;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JList keyList;
    private JButton refreshBtn;
    private JButton remBtn;
    private JButton saveBtn;
    private JTextArea valBox;

    public Globals() {
        this.initComponents();
    }

    private void initComponents() {
        this.addBtn = new JButton();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.keyList = new JList();
        this.remBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.valBox = new JTextArea();
        this.refreshBtn = new JButton();
        this.saveBtn = new JButton();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Global Variables");
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/net/apocalypselabs/symat/icons/globals.png")));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                Globals.this.formComponentShown(evt);
            }
        });
        this.addBtn.setText("Add");
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Globals.this.addBtnActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Variables"));
        this.keyList.setSelectionMode(0);
        this.keyList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                Globals.this.keyListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.keyList);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 109, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 212, Short.MAX_VALUE)));
        this.remBtn.setText("Remove");
        this.remBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Globals.this.remBtnActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Value"));
        this.valBox.setColumns(1);
        this.valBox.setRows(1);
        this.valBox.setTabSize(4);
        this.jScrollPane2.setViewportView(this.valBox);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 202, Short.MAX_VALUE).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2)));
        this.refreshBtn.setText("Refresh");
        this.refreshBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Globals.this.refreshBtnActionPerformed(evt);
            }
        });
        this.saveBtn.setText("Save");
        this.saveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Globals.this.saveBtnActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.addBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.remBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveBtn).addGap(37, 37, 37).addComponent(this.refreshBtn).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addBtn).addComponent(this.remBtn).addComponent(this.refreshBtn).addComponent(this.saveBtn)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void keyListValueChanged(ListSelectionEvent evt) {
        if (this.keyList.getSelectedValue() != null) {
            this.valBox.setEditable(true);
            try {
                Object item = Functions.GLOBALS.get(this.keyList.getSelectedValue());
                if (item == null) {
                    this.valBox.setText("");
                    this.valBox.setEditable(true);
                } else if (item.getClass().equals(NativeArray.class)) {
                    Object[] arr = ((NativeArray)item).toArray();
                    this.valBox.setText(Arrays.toString(arr));
                    this.valBox.setEditable(false);
                } else {
                    this.valBox.setText(Functions.GLOBALS.get(this.keyList.getSelectedValue()).toString());
                }
            }
            catch (Exception ex) {
                this.valBox.setText("error");
                this.valBox.setEditable(false);
                Debug.stacktrace(ex);
            }
        }
    }

    private void addBtnActionPerformed(ActionEvent evt) {
        String name = JOptionPane.showInternalInputDialog(this, "New variable name:", "New global", -1);
        if (name != null && !name.equals("")) {
            Functions.GLOBALS.put(name, null);
            this.refreshList();
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        this.refreshList();
    }

    private void remBtnActionPerformed(ActionEvent evt) {
        int choice;
        if (this.keyList.getSelectedValue() != null && (choice = JOptionPane.showInternalConfirmDialog(this, "Delete variable '" + this.keyList.getSelectedValue().toString() + "'?", "Delete?", 0)) == 0) {
            Functions.GLOBALS.remove(this.keyList.getSelectedValue().toString());
            this.refreshList();
        }
    }

    private void refreshBtnActionPerformed(ActionEvent evt) {
        this.refreshList();
    }

    private void saveBtnActionPerformed(ActionEvent evt) {
        try {
            this.setVar(this.keyList.getSelectedValue().toString(), this.valBox.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void refreshList() {
        this.keyList.setListData(Functions.GLOBALS.keySet().toArray());
        this.valBox.setText("");
    }

    private void setVar(String key, String val) {
        try {
            double value = Double.parseDouble(val);
            Functions.GLOBALS.put(key, value);
        }
        catch (Exception ex) {
            Functions.GLOBALS.put(key, val);
        }
        this.refreshList();
    }
}

