/*
 * Decompiled with CFR 0.152.
 */
package net.apocalypselabs.symat;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import net.apocalypselabs.symat.BadInputException;
import net.apocalypselabs.symat.ExitControl;
import net.apocalypselabs.symat.FileUtils;
import net.apocalypselabs.symat.Graph;
import net.apocalypselabs.symat.Main;
import net.apocalypselabs.symat.PrefStorage;
import net.apocalypselabs.symat.WebBrowser;
import net.apocalypselabs.symat.components.TextBox;
import org.matheclipse.core.eval.EvalUtilities;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.parser.client.math.MathException;
import org.mozilla.javascript.NativeArray;
import org.python.core.PyList;

public class Functions {
    public static final HashMap<String, Object> GLOBALS = new HashMap();
    private final EvalUtilities util = new EvalUtilities(true, true);
    Graph graphwin = new Graph(true);
    private String lang = "py";
    private final SecureRandom rng = new SecureRandom();

    public void notify(Object message) {
        JOptionPane.showInternalMessageDialog(Main.mainPane, message.toString());
    }

    public void alert(Object message) {
        this.notify(message);
    }

    public String ask(String question) {
        return JOptionPane.showInternalInputDialog(Main.mainPane, question);
    }

    public void pause(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void sleep(long millis) {
        this.pause(millis);
    }

    public void quitApplication() {
        new ExitControl().windowClosing(null);
    }

    public String factorial(long n) throws BadInputException {
        if (n <= 0L) {
            throw new BadInputException("Input must be greater than zero!");
        }
        BigInteger inc = new BigInteger("1");
        BigInteger fact = new BigInteger("1");
        for (long c = 1L; c <= n; ++c) {
            fact = fact.multiply(inc);
            inc = inc.add(BigInteger.ONE);
        }
        return fact.toString();
    }

    public double powermod(double a, double b, double m) {
        if (b == -1.0) {
            BigInteger in = new BigInteger(String.valueOf((int)a));
            return in.modInverse(new BigInteger(String.valueOf((int)m))).doubleValue();
        }
        return (Math.pow(a, b) % m + m) % m;
    }

    public String powermod(String a, String b, String m) {
        BigInteger in = new BigInteger(a);
        if (b.equals("-1")) {
            return in.modInverse(new BigInteger(m)).toString();
        }
        return in.modPow(new BigInteger(b), new BigInteger(m)).toString();
    }

    public long gcd(long a, long b) {
        if (b == 0L) {
            return a;
        }
        return this.gcd(b, a % b);
    }

    public String gcd(String a, String b) {
        return new BigInteger(a).gcd(new BigInteger(b)).toString();
    }

    public String diff(String function, String idv) {
        return this.util.evaluate("diff(" + function + "," + idv + ")").toString();
    }

    public String diff(String function) {
        return this.diff(function, "x");
    }

    @Deprecated
    public String D(String function, String idv) {
        return this.diff(function, idv);
    }

    public double[] solve(String function, String idv, int eq) {
        String res = this.$("Solve[" + function + "==" + eq + ", " + idv + "]");
        res = res.substring(1, res.length() - 1);
        String[] cmp = res.split(",");
        for (int i = 0; i < cmp.length; ++i) {
            cmp[i] = cmp[i].replace("{" + idv + "->", "");
            cmp[i] = cmp[i].replace("}", "");
        }
        double[] out = new double[cmp.length];
        for (int i = 0; i < cmp.length; ++i) {
            try {
                if (cmp[i].contains("I")) {
                    if (cmp[i].contains("-I")) {
                        out[i] = Double.NEGATIVE_INFINITY;
                        continue;
                    }
                    out[i] = Double.POSITIVE_INFINITY;
                    continue;
                }
                out[i] = Double.parseDouble(cmp[i]);
                continue;
            }
            catch (Exception ex) {
                return new double[]{Double.NaN};
            }
        }
        return out;
    }

    public double[] solve(String function, String idv) {
        return this.solve(function, idv, 0);
    }

    public double[] solve(String function) {
        return this.solve(function, "x");
    }

    private String printa(double[] o) {
        String out = "[";
        for (int i = 0; i < o.length; ++i) {
            out = out + o[i] + (i == o.length - 1 ? "" : ", ");
        }
        out = out + "]";
        return out;
    }

    private String printa(int[] o) {
        String out = "[";
        for (int i = 0; i < o.length; ++i) {
            out = out + o[i] + (i == o.length - 1 ? "" : ", ");
        }
        out = out + "]";
        return out;
    }

    private String printa(boolean[] o) {
        String out = "[";
        for (int i = 0; i < o.length; ++i) {
            out = out + (o[i] ? "true" : "false") + (i == o.length - 1 ? "" : ", ");
        }
        out = out + "]";
        return out;
    }

    public String printa(Object o) {
        String out = "[";
        if (o instanceof int[]) {
            int[] arr = (int[])o;
            for (int i = 0; i < arr.length; ++i) {
                out = out + arr[i] + (i == arr.length - 1 ? "" : ", ");
            }
        } else if (o instanceof double[]) {
            double[] arr = (double[])o;
            for (int i = 0; i < arr.length; ++i) {
                out = out + arr[i] + (i == arr.length - 1 ? "" : ", ");
            }
        } else if (o instanceof boolean[]) {
            double[] arr = (double[])o;
            for (int i = 0; i < arr.length; ++i) {
                out = out + arr[i] + (i == arr.length - 1 ? "" : ", ");
            }
        } else if (o instanceof int[][]) {
            int[][] arr = (int[][])o;
            for (int i = 0; i < arr.length; ++i) {
                out = out + this.printa(arr[i]) + (i == arr.length - 1 ? "" : ", ");
            }
        } else if (o instanceof double[][]) {
            double[][] arr = (double[][])o;
            for (int i = 0; i < arr.length; ++i) {
                out = out + this.printa(arr[i]) + (i == arr.length - 1 ? "" : ", ");
            }
        } else if (o instanceof boolean[][]) {
            boolean[][] arr = (boolean[][])o;
            for (int i = 0; i < arr.length; ++i) {
                out = out + this.printa(arr[i]) + (i == arr.length - 1 ? "" : ", ");
            }
        } else if (o instanceof NativeArray) {
            NativeArray arr = (NativeArray)o;
            for (long i = 0L; i < arr.getLength(); ++i) {
                out = out + (arr.get(i) instanceof NativeArray ? this.printa(arr.get(i)) : arr.get(i).toString()) + (i == arr.getLength() - 1L ? "" : ", ");
            }
        } else if (o instanceof PyList) {
            PyList arr = (PyList)o;
            Object[] oo = arr.toArray();
            for (int i = 0; i < oo.length; ++i) {
                out = out + (oo[i] instanceof Object[] ? this.printa(oo[i]) : oo[i].toString()) + (i == oo.length - 1 ? "" : ", ");
            }
        } else {
            Object[] arr = (Object[])o;
            for (int i = 0; i < arr.length; ++i) {
                out = out + (arr[i] instanceof Object[] ? this.printa(arr[i]) : arr[i].toString()) + (i == arr.length - 1 ? "" : ", ");
            }
        }
        out = out + "]";
        return out;
    }

    public String integrate(String function, String idv) {
        return this.util.evaluate("integrate(" + function + "," + idv + ")").toString();
    }

    public String integrate(String function) {
        return this.integrate(function, "x");
    }

    public String factor(String function) {
        return this.sym("Factor(" + function + ")");
    }

    public String simplify(String expr) {
        return this.sym("Simplify(" + expr + ")");
    }

    public Object vpa(String expr) {
        IExpr ans = this.util.evaluate("N(" + expr + ")");
        if (ans.isNumber()) {
            return Double.parseDouble(ans.toString());
        }
        return ans.toString();
    }

    public int[] primes(int in) {
        int i;
        boolean[] prime = new boolean[in];
        for (i = 0; i < prime.length; ++i) {
            prime[i] = true;
        }
        i = 2;
        while ((double)i < Math.sqrt(in)) {
            if (prime[i]) {
                int x = 0;
                int j = i * i;
                while (j < in) {
                    prime[j] = false;
                    j = i * i + ++x * i;
                }
            }
            ++i;
        }
        ArrayList<Integer> arr = new ArrayList<Integer>();
        for (int i2 = 2; i2 < prime.length; ++i2) {
            if (!prime[i2]) continue;
            arr.add(i2);
        }
        int[] out = new int[arr.size()];
        for (int i3 = 0; i3 < arr.size(); ++i3) {
            out[i3] = (Integer)arr.get(i3);
        }
        return out;
    }

    public double sec(double d) {
        return 1.0 / Math.cos(d);
    }

    public double csc(double d) {
        return 1.0 / Math.sin(d);
    }

    public double cot(double d) {
        return 1.0 / Math.tan(d);
    }

    public double asec(double d) {
        return Math.acos(1.0 / d);
    }

    public double acsc(double d) {
        return Math.asin(1.0 / d);
    }

    public double acot(double d) {
        return Math.atan(1.0 / d);
    }

    public double sinh(double d) {
        return Math.sinh(d);
    }

    public double cosh(double d) {
        return Math.cosh(d);
    }

    public double tanh(double d) {
        return Math.tanh(d);
    }

    public double sech(double d) {
        return Math.pow(Math.cosh(d), -1.0);
    }

    public double csch(double d) {
        return Math.pow(Math.sinh(d), -1.0);
    }

    public double coth(double d) {
        return Math.cosh(d) / Math.sinh(d);
    }

    public double times(double ... a) {
        double ans = 0.0;
        for (int i = 0; i < a.length; ++i) {
            if (i == 0) {
                ans = a[i];
                continue;
            }
            ans *= a[i];
        }
        return ans;
    }

    public String times(String a, String b) {
        return new BigInteger(a).multiply(new BigInteger(b)).toString();
    }

    public double divide(double ... a) {
        double ans = 0.0;
        for (int i = 0; i < a.length; ++i) {
            if (i == 0) {
                ans = a[i];
                continue;
            }
            ans /= a[i];
        }
        return ans;
    }

    public String divide(String a, String b) {
        return new BigInteger(a).divide(new BigInteger(b)).toString();
    }

    public double mod(double ... a) {
        double ans = 0.0;
        for (int i = 0; i < a.length; ++i) {
            if (i == 0) {
                ans = a[i];
                continue;
            }
            ans %= a[i];
        }
        return ans;
    }

    public String mod(String a, String b) {
        return new BigInteger(a).mod(new BigInteger(b)).toString();
    }

    public double[] intArrayToDouble(int[] a) {
        double[] out = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            out[i] = a[i];
        }
        return out;
    }

    public int[] doubleArrayToInt(double[] a) {
        int[] out = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            out[i] = Math.round((float)a[i]);
        }
        return out;
    }

    public double add(double ... a) {
        double ans = 0.0;
        for (double d : a) {
            ans += d;
        }
        return ans;
    }

    public String add(String a, String b) {
        return new BigInteger(a).subtract(new BigInteger(b)).toString();
    }

    public double subtract(double ... a) {
        double ans = 0.0;
        for (int i = 0; i < a.length; ++i) {
            if (i == 0) {
                ans = a[i];
                continue;
            }
            ans -= a[i];
        }
        return ans;
    }

    public String subtract(String a, String b) {
        BigInteger ans = new BigInteger(a);
        ans = ans.subtract(new BigInteger(b));
        return ans.toString();
    }

    public double[][] minvert(double[][] a) {
        int k;
        int j;
        int i;
        int n = a.length;
        double[][] x = new double[n][n];
        double[][] b = new double[n][n];
        int[] index = new int[n];
        for (i = 0; i < n; ++i) {
            b[i][i] = 1.0;
        }
        this.gaussian(a, index);
        for (i = 0; i < n - 1; ++i) {
            for (j = i + 1; j < n; ++j) {
                for (k = 0; k < n; ++k) {
                    double[] dArray = b[index[j]];
                    int n2 = k;
                    dArray[n2] = dArray[n2] - a[index[j]][i] * b[index[i]][k];
                }
            }
        }
        for (i = 0; i < n; ++i) {
            x[n - 1][i] = b[index[n - 1]][i] / a[index[n - 1]][n - 1];
            for (j = n - 2; j >= 0; --j) {
                x[j][i] = b[index[j]][i];
                for (k = j + 1; k < n; ++k) {
                    double[] dArray = x[j];
                    int n3 = i;
                    dArray[n3] = dArray[n3] - a[index[j]][k] * x[k][i];
                }
                double[] dArray = x[j];
                int n4 = i;
                dArray[n4] = dArray[n4] / a[index[j]][j];
            }
        }
        return x;
    }

    private void gaussian(double[][] a, int[] index) {
        int i;
        int n = index.length;
        double[] c = new double[n];
        for (i = 0; i < n; ++i) {
            index[i] = i;
        }
        for (i = 0; i < n; ++i) {
            double c1 = 0.0;
            for (int j = 0; j < n; ++j) {
                double c0 = Math.abs(a[i][j]);
                if (!(c0 > c1)) continue;
                c1 = c0;
            }
            c[i] = c1;
        }
        int k = 0;
        for (int j = 0; j < n - 1; ++j) {
            double pi1 = 0.0;
            for (int i2 = j; i2 < n; ++i2) {
                double pi0 = Math.abs(a[index[i2]][j]);
                if (!((pi0 /= c[index[i2]]) > pi1)) continue;
                pi1 = pi0;
                k = i2;
            }
            int itmp = index[j];
            index[j] = index[k];
            index[k] = itmp;
            for (int i3 = j + 1; i3 < n; ++i3) {
                double pj;
                a[index[i3]][j] = pj = a[index[i3]][j] / a[index[j]][j];
                for (int l = j + 1; l < n; ++l) {
                    double[] dArray = a[index[i3]];
                    int n2 = l;
                    dArray[n2] = dArray[n2] - pj * a[index[j]][l];
                }
            }
        }
    }

    public long[] factor(long n) {
        HashSet<Long> primes = new HashSet<Long>();
        long copyOfInput = n;
        for (long i = 2L; i <= copyOfInput; ++i) {
            if (copyOfInput % i != 0L) continue;
            primes.add(i);
            copyOfInput /= i;
            --i;
        }
        long[] a = new long[primes.size()];
        int j = 0;
        for (Object e : primes) {
            a[j++] = (Long)e;
        }
        return a;
    }

    public boolean isprime(long n) {
        int i = 2;
        while ((double)i <= Math.sqrt(n)) {
            if (n % (long)i == 0L) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isprime(String nn) {
        BigInteger n = new BigInteger(nn);
        BigInteger i = new BigInteger("2");
        BigInteger ns = this.bigIntSqRootCeil(n);
        while (i.compareTo(ns) <= 0) {
            if (n.mod(i).toString().equals("0")) {
                return false;
            }
            i = i.add(BigInteger.ONE);
        }
        return true;
    }

    private BigInteger bigIntSqRootCeil(BigInteger x) throws IllegalArgumentException {
        if (x.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("Negative argument.");
        }
        if (x == BigInteger.ZERO || x == BigInteger.ONE) {
            return x;
        }
        BigInteger two = BigInteger.valueOf(2L);
        BigInteger y = x.divide(two);
        while (y.compareTo(x.divide(y)) > 0) {
            y = x.divide(y).add(y).divide(two);
        }
        if (x.compareTo(y.multiply(y)) == 0) {
            return y;
        }
        return y.add(BigInteger.ONE);
    }

    public Object[] perms(Object ... objs) {
        Permutations<Object> perm = new Permutations<Object>(objs);
        HashSet<Object[]> perms = new HashSet<Object[]>();
        while (perm.hasNext()) {
            perms.add(perm.next());
        }
        Object[][] a = new Object[perms.size()][objs.length];
        return perms.toArray((T[])a);
    }

    public double rand() {
        return this.rng.nextDouble();
    }

    public boolean randb() {
        return this.rng.nextBoolean();
    }

    public double rand(int min, int max) {
        if (min == 0 && max == 0) {
            return this.rand();
        }
        return this.rng.nextInt(max - min + 1) + min;
    }

    public double[][] mtimes(double[][] a, double[][] b) throws BadInputException {
        double[][] ans = new double[a.length][b[0].length];
        double sum = 0.0;
        int m = a.length;
        int q = b[0].length;
        int p = b.length;
        if (a[0].length != b.length) {
            throw new BadInputException("First matrix column count must match second matrix row count.");
        }
        for (int c = 0; c < m; ++c) {
            for (int d = 0; d < q; ++d) {
                for (int k = 0; k < p; ++k) {
                    sum += a[c][k] * b[k][d];
                }
                ans[c][d] = sum;
                sum = 0.0;
            }
        }
        return ans;
    }

    public double[][] mpower(double[][] a, int b) throws BadInputException {
        if (a.length != a[0].length) {
            throw new BadInputException("Matrix needs to be square.");
        }
        if (b < 0) {
            throw new BadInputException("Power cannot be negative.");
        }
        double[][] ans = a;
        for (int i = 0; i < b; ++i) {
            ans = i == 0 ? a : this.mtimes(a, ans);
        }
        return ans;
    }

    public double rad(double degrees) {
        return degrees * (Math.PI / 180);
    }

    public double deg(double radians) {
        return radians * 57.29577951308232;
    }

    public String sym(String input) {
        return this.util.evaluate(input).toString();
    }

    public String $(String input) {
        return this.sym(input);
    }

    public String replace(String function, String variable, String newvar) {
        return function.replaceAll(variable, newvar);
    }

    public double subs(String function, String variable, String newvar) {
        return this.numof(function.replaceAll(variable, newvar));
    }

    public double numof(String f) {
        try {
            return Double.parseDouble(this.util.evaluate("N(" + f + ")").toString());
        }
        catch (NumberFormatException | MathException ex) {
            return 0.0;
        }
    }

    public void xlim(double xmin, double xmax) {
        this.graphwin.setRange(xmin, xmax);
    }

    public void plot(String function) {
        this.showGraph();
        if (!function.equals("")) {
            this.graphwin.graphFunction(function);
        }
    }

    public void plot(double[] x, double[] y) {
        this.graphwin.plotPoints(x, y);
    }

    public void plot(double[] x, double[] y, String name) {
        this.graphwin.plotPoints(x, y, name);
    }

    public void plot(String function, double xmin, double xmax) {
        this.graphwin.setRange(xmin, xmax);
        this.plot(function);
    }

    public void ezplot(String f) {
        this.plot(f);
    }

    public void ezplot(String function, double xmin, double xmax) {
        this.plot(function, xmin, xmax);
    }

    public void graph(String f) {
        this.plot(f);
    }

    public String plotname() {
        return this.graphwin.getTitle();
    }

    public String plotname(String t) {
        if (t.equals("symatpythonnullplotname")) {
            return this.graphwin.getTitle();
        }
        this.graphwin.setWindowTitle(t);
        this.graphwin.setLabel(t);
        return "";
    }

    public void plot() {
        this.showGraph();
    }

    public void plotclr() {
        this.graphwin.clearDraw();
    }

    public void clearplot() {
        this.plotclr();
    }

    public void plotclear() {
        this.plotclr();
    }

    public void drawdot(double x, double y) {
        this.showGraph();
        this.graphwin.drawDot(x, y);
    }

    public String readfile(String path) throws IOException {
        return FileUtils.readFile(path);
    }

    public void savefile(String content, String path) throws IOException {
        FileUtils.saveFile(content, path, false);
    }

    public String filedialog() {
        JFileChooser fc = new JFileChooser();
        int result = fc.showDialog((Component)((Object)Main.maingui), "Choose");
        if (result == 0) {
            return fc.getSelectedFile().getPath();
        }
        return "";
    }

    public String md5sum(String data) {
        return FileUtils.MD5(data);
    }

    public void save(String key, String val) {
        Preferences prefs = Preferences.userNodeForPackage(Functions.class);
        prefs.put(key, val);
        try {
            prefs.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String load(String key) {
        Preferences prefs = Preferences.userNodeForPackage(Functions.class);
        return prefs.get(key, "");
    }

    public String sysinfo() {
        String info = "==Java Information==\n";
        info = info + "Java version: " + System.getProperty("java.version");
        info = info + "\nJava vendor: " + System.getProperty("java.vendor");
        info = info + "\nJava home: " + System.getProperty("java.home");
        return info;
    }

    public void resetlicense() {
        int result = JOptionPane.showConfirmDialog(null, "Are you sure you want to reset your license?\nThis will close SyMAT and all open files!", "Reset license", 1, 3);
        if (result == 0) {
            PrefStorage.unset("license");
            System.exit(0);
        }
    }

    public String license() {
        String expires;
        block33: {
            expires = "Error";
            if (PrefStorage.getSetting("licensetype").equals("demo")) {
                Calendar c = Calendar.getInstance();
                c.setTime(new Date());
                try {
                    long expire = Long.parseLong(PrefStorage.getSetting("license"));
                    long days = ((expire - c.getTimeInMillis()) / 86400L - 999L) / 1000L;
                    if (days < 0L) {
                        expires = days == -1L ? "Today" : Math.abs(days) + " days ago";
                        break block33;
                    }
                    expires = "In " + days + " days";
                }
                catch (NumberFormatException expire) {}
            } else {
                try {
                    URL url = new URL("http://apis.symatapp.com/expire.php?email=" + PrefStorage.getSetting("license"));
                    try (InputStream is = url.openStream();
                         BufferedReader br = new BufferedReader(new InputStreamReader(is));){
                        expires = br.readLine();
                    }
                    catch (IOException iOException) {}
                }
                catch (Exception url) {
                    // empty catch block
                }
            }
        }
        String lic = "==License Information==\nLicense: " + PrefStorage.getSetting("license") + "\nType: " + PrefStorage.getSetting("licensetype") + "\nExpires: " + expires;
        return lic;
    }

    private void showGraph() {
        this.graphwin.setVisible(true);
        this.graphwin.toFront();
    }

    public TextBox textbox() {
        return new TextBox();
    }

    public WebBrowser browser() {
        return new WebBrowser();
    }

    public Functions() {
        Main.loadFrame(this.graphwin, false);
    }

    public void setLang(String l) {
        this.lang = l;
    }

    class Permutations<E>
    implements Iterator<E[]> {
        private final E[] arr;
        private final int[] ind;
        private boolean has_next;
        public E[] output;

        Permutations(E[] arr) {
            this.arr = (Object[])arr.clone();
            this.ind = new int[arr.length];
            HashMap<E, Integer> hm = new HashMap<E, Integer>();
            for (int i = 0; i < arr.length; ++i) {
                Integer n = (Integer)hm.get(arr[i]);
                if (n == null) {
                    hm.put(arr[i], i);
                    n = i;
                }
                this.ind[i] = n;
            }
            Arrays.sort(this.ind);
            this.output = (Object[])Array.newInstance(arr.getClass().getComponentType(), arr.length);
            this.has_next = true;
        }

        @Override
        public boolean hasNext() {
            return this.has_next;
        }

        @Override
        public E[] next() {
            if (!this.has_next) {
                throw new NoSuchElementException();
            }
            for (int i = 0; i < this.ind.length; ++i) {
                this.output[i] = this.arr[this.ind[i]];
            }
            this.has_next = false;
            for (int tail = this.ind.length - 1; tail > 0; --tail) {
                if (this.ind[tail - 1] >= this.ind[tail]) continue;
                int s = this.ind.length - 1;
                while (this.ind[tail - 1] >= this.ind[s]) {
                    --s;
                }
                this.swap(this.ind, tail - 1, s);
                int i = tail;
                for (int j = this.ind.length - 1; i < j; ++i, --j) {
                    this.swap(this.ind, i, j);
                }
                this.has_next = true;
                break;
            }
            return this.output;
        }

        private void swap(int[] arr, int i, int j) {
            int t = arr[i];
            arr[i] = arr[j];
            arr[j] = t;
        }

        @Override
        public void remove() {
        }
    }
}

