/*
 * Decompiled with CFR 0.152.
 */
package net.apocalypselabs.symat;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Scanner;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.apocalypselabs.symat.Main;

public class FileUtils {
    public static String readFile(String path) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, StandardCharsets.UTF_8);
    }

    public static File getFileWithExtension(JFileChooser c) {
        File file = c.getSelectedFile();
        if (c.getFileFilter() instanceof FileNameExtensionFilter) {
            String[] exts = ((FileNameExtensionFilter)c.getFileFilter()).getExtensions();
            String nameLower = file.getName().toLowerCase();
            for (String ext : exts) {
                if (!nameLower.endsWith('.' + ext.toLowerCase())) continue;
                return file;
            }
            file = new File(file.toString() + '.' + exts[0]);
        }
        return file;
    }

    public static void saveFile(String content, String path, boolean addToRecent) throws IOException {
        try (PrintStream out = new PrintStream(new FileOutputStream(path));){
            out.print(content);
        }
        if (addToRecent) {
            Main.addRecentFile(new File(path).getAbsolutePath());
        }
    }

    public static String MD5(String md5) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] array = md.digest(md5.getBytes());
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < array.length; ++i) {
                sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).substring(1, 3));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public static String getUrl(String url) throws MalformedURLException, IOException {
        String out;
        try (Scanner sc = new Scanner(new URL(url).openStream(), "UTF-8");){
            out = sc.useDelimiter("\\A").next();
        }
        return out;
    }
}

