/*
 * Decompiled with CFR 0.152.
 */
package net.apocalypselabs.symat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.JTextComponent;
import net.apocalypselabs.symat.CodeCompleter;
import net.apocalypselabs.symat.CodeExport;
import net.apocalypselabs.symat.CodeRunner;
import net.apocalypselabs.symat.Debug;
import net.apocalypselabs.symat.FileUtils;
import net.apocalypselabs.symat.Main;
import net.apocalypselabs.symat.PackagePlugin;
import net.apocalypselabs.symat.Pads;
import net.apocalypselabs.symat.PrefStorage;
import net.apocalypselabs.symat.SharePad;
import net.apocalypselabs.symat.Theme;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class Editor
extends JInternalFrame {
    private CodeRunner cr;
    private RunThread rt;
    private UpdateOutput uo;
    private final JFileChooser fc = new JFileChooser();
    private boolean isSaved = false;
    private RSyntaxTextArea codeBox = new RSyntaxTextArea();
    private final RTextScrollPane sp;
    private boolean fileChanged = false;
    private CompletionProvider jscomp = new CodeCompleter("js").getProvider();
    private CompletionProvider javacomp = new CodeCompleter("java").getProvider();
    private CompletionProvider pycomp = new CodeCompleter("py").getProvider();
    private AutoCompletion jsac = new AutoCompletion(this.jscomp);
    private AutoCompletion pyac = new AutoCompletion(this.pycomp);
    private AutoCompletion javaac = new AutoCompletion(this.javacomp);
    public static final int JAVASCRIPT = 1;
    public static final int PYTHON = 2;
    public static final int JAVA = 3;
    private File filedata;
    private int font_size = 12;
    private JButton clearBtn;
    private JMenu codeLangMenu;
    private JMenuItem copyBtn;
    private JMenuItem cutBtn;
    private JMenu editMenu;
    private JPanel editPanel;
    private JMenuItem exportMenu;
    private JMenu fileMenu;
    private JLabel jLabel1;
    private JMenu jMenu1;
    private JMenu jMenu3;
    private JMenu jMenu4;
    private JMenuBar jMenuBar1;
    private JMenuBar jMenuBar2;
    private JMenuItem jMenuItem4;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JPopupMenu.Separator jSeparator1;
    private JSplitPane jSplitPane1;
    private JRadioButtonMenuItem javaOption;
    private JRadioButtonMenuItem javascriptOption;
    private JMenuItem killButton;
    private ButtonGroup langBtnGroup;
    private JMenuItem openMenu;
    private JMenu openSampleBtn;
    private JTextArea outputBox;
    private JPanel outputPanel;
    private JMenuItem packPluginMenu;
    private JMenuItem pasteBtn;
    private JRadioButtonMenuItem pythonOption;
    private JMenuItem redoBtn;
    private JMenuItem runCodeBtn;
    private JMenu runMenu;
    private JMenuItem sampleGraph;
    private JMenuItem sampleHelloWorld;
    private JMenuItem saveAsMenu;
    private JMenuItem saveMenu;
    private JMenuItem shareAsMenu;
    private JMenuItem shareMenu;
    private JMenuItem undoBtn;

    @Deprecated
    public Editor(boolean python) {
        this(python ? 2 : 1);
    }

    public Editor(int lang) {
        this.initComponents();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("All SyMAT Files", "syjs", "js", "sypy", "py", "syjava", "java");
        this.fc.setFileFilter(filter);
        this.fc.addChoosableFileFilter(filter);
        this.fc.addChoosableFileFilter(new FileNameExtensionFilter("JavaScript (syjs, js)", "syjs", "js"));
        this.fc.addChoosableFileFilter(new FileNameExtensionFilter("Python (sypy, py)", "sypy", "py"));
        this.fc.addChoosableFileFilter(new FileNameExtensionFilter("Java (syjava, java)", "syjava", "java"));
        this.fc.addChoosableFileFilter(new FileNameExtensionFilter("Plain Text (txt, text)", "txt", "text"));
        try {
            this.font_size = Integer.valueOf(PrefStorage.getSetting("editfont"));
        }
        catch (Exception ex) {
            Debug.printerr("Font size error!");
        }
        this.codeBox.setFont(new Font("Monospaced", 0, this.font_size));
        this.outputBox.setFont(new Font("Monospaced", 0, this.font_size));
        this.loadTheme();
        this.codeBox.setCodeFoldingEnabled(true);
        this.codeBox.setAntiAliasingEnabled(true);
        this.sp = new RTextScrollPane((Component)this.codeBox);
        this.sp.setFoldIndicatorEnabled(true);
        this.editPanel.add((Component)this.sp);
        this.codeBox.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Editor.this.formMouseClicked(evt);
            }
        });
        if (lang == 2) {
            this.pyac.install((JTextComponent)this.codeBox);
            this.javascriptOption.setSelected(false);
            this.pythonOption.setSelected(true);
            this.codeBox.setSyntaxEditingStyle("text/python");
        } else if (lang == 3) {
            this.javaac.install((JTextComponent)this.codeBox);
            this.javascriptOption.setSelected(false);
            this.javaOption.setSelected(true);
            this.codeBox.setSyntaxEditingStyle("text/java");
        } else {
            this.jsac.install((JTextComponent)this.codeBox);
            this.codeBox.setSyntaxEditingStyle("text/javascript");
        }
        this.sp.setVisible(true);
        this.codeBox.setVisible(true);
        this.codeBox.requestFocus();
        this.codeBox.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.changed();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changed();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changed();
            }

            public void changed() {
                Editor.this.fileChanged = true;
            }
        });
    }

    public Editor(String text) {
        this();
        this.codeBox.setText(text);
    }

    public Editor(String text, boolean openSaveDialog) {
        this(text);
        if (openSaveDialog) {
            this.saveAsMenuActionPerformed(null);
        }
    }

    public Editor() {
        this(false);
    }

    public Editor(long openfile) {
        this("");
        this.openMenuActionPerformed(null);
    }

    private void setEditorTheme(String themeName) {
        try {
            org.fife.ui.rsyntaxtextarea.Theme theme = org.fife.ui.rsyntaxtextarea.Theme.load((InputStream)Editor.class.getResourceAsStream("resources/" + themeName + ".xml"), (Font)new Font("Monospaced", 0, this.font_size));
            theme.apply(this.codeBox);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadTheme() {
        this.outputBox.setBackground(Theme.boxColor());
        this.outputBox.setForeground(Theme.textColor());
        this.setBackground(Theme.windowColor());
        this.setEditorTheme(Theme.editorTheme());
    }

    private void initComponents() {
        this.jMenuItem4 = new JMenuItem();
        this.jMenuBar2 = new JMenuBar();
        this.jMenu3 = new JMenu();
        this.jMenu4 = new JMenu();
        this.langBtnGroup = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.outputPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.outputBox = new JTextArea();
        this.clearBtn = new JButton();
        this.editPanel = new JPanel();
        this.jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenu = new JMenuItem();
        this.openSampleBtn = new JMenu();
        this.sampleHelloWorld = new JMenuItem();
        this.sampleGraph = new JMenuItem();
        this.saveMenu = new JMenuItem();
        this.saveAsMenu = new JMenuItem();
        this.jMenu1 = new JMenu();
        this.exportMenu = new JMenuItem();
        this.packPluginMenu = new JMenuItem();
        this.shareMenu = new JMenuItem();
        this.shareAsMenu = new JMenuItem();
        this.editMenu = new JMenu();
        this.undoBtn = new JMenuItem();
        this.redoBtn = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.cutBtn = new JMenuItem();
        this.copyBtn = new JMenuItem();
        this.pasteBtn = new JMenuItem();
        this.runMenu = new JMenu();
        this.runCodeBtn = new JMenuItem();
        this.killButton = new JMenuItem();
        this.codeLangMenu = new JMenu();
        this.javascriptOption = new JRadioButtonMenuItem();
        this.pythonOption = new JRadioButtonMenuItem();
        this.javaOption = new JRadioButtonMenuItem();
        this.jMenuItem4.setText("jMenuItem4");
        this.jMenu3.setText("File");
        this.jMenuBar2.add(this.jMenu3);
        this.jMenu4.setText("Edit");
        this.jMenuBar2.add(this.jMenu4);
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Editor");
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/net/apocalypselabs/symat/icons/editor.png")));
        this.setMinimumSize(new Dimension(125, 50));
        this.setPreferredSize(new Dimension(550, 375));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Editor.this.formMouseClicked(evt);
            }
        });
        this.jSplitPane1.setDividerLocation(200);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.7);
        this.jLabel1.setText("Output:");
        this.outputBox.setEditable(false);
        this.outputBox.setColumns(20);
        this.outputBox.setLineWrap(true);
        this.outputBox.setRows(3);
        this.outputBox.setWrapStyleWord(true);
        this.outputBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Editor.this.outputBoxMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.outputBox);
        this.clearBtn.setText("Clear");
        this.clearBtn.setToolTipText("");
        this.clearBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Editor.this.clearBtnActionPerformed(evt);
            }
        });
        GroupLayout outputPanelLayout = new GroupLayout(this.outputPanel);
        this.outputPanel.setLayout(outputPanelLayout);
        outputPanelLayout.setHorizontalGroup(outputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(outputPanelLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.clearBtn)).addComponent(this.jScrollPane1, -1, 532, Short.MAX_VALUE));
        outputPanelLayout.setVerticalGroup(outputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(outputPanelLayout.createSequentialGroup().addGroup(outputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.clearBtn, -2, 18, -2)).addGap(0, 0, 0).addComponent(this.jScrollPane1, -1, 100, Short.MAX_VALUE)));
        this.jSplitPane1.setRightComponent(this.outputPanel);
        this.editPanel.setLayout(new BorderLayout());
        this.jSplitPane1.setLeftComponent(this.editPanel);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1));
        this.fileMenu.setText("File");
        this.openMenu.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openMenu.setText("Open...");
        this.openMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Editor.this.openMenuActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenu);
        this.openSampleBtn.setText("Open Code Sample");
        this.sampleHelloWorld.setAccelerator(KeyStroke.getKeyStroke(49, 3));
        this.sampleHelloWorld.setText("helloworld");
        this.sampleHelloWorld.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Editor.this.sampleHelloWorldActionPerformed(evt);
            }
        });
        this.openSampleBtn.add(this.sampleHelloWorld);
        this.sampleGraph.setAccelerator(KeyStroke.getKeyStroke(50, 3));
        this.sampleGraph.setText("graph");
        this.sampleGraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Editor.this.sampleGraphActionPerformed(evt);
            }
        });
        this.openSampleBtn.add(this.sampleGraph);
        this.fileMenu.add(this.openSampleBtn);
        this.saveMenu.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveMenu.setText("Save...");
        this.saveMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Editor.this.saveMenuActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveMenu);
        this.saveAsMenu.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        this.saveAsMenu.setText("Save as...");
        this.saveAsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Editor.this.saveAsMenuActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveAsMenu);
        this.jMenu1.setText("Publish");
        this.jMenu1.setToolTipText("");
        this.exportMenu.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.exportMenu.setText("Export code");
        this.exportMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Editor.this.exportMenuActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.exportMenu);
        this.packPluginMenu.setAccelerator(KeyStroke.getKeyStroke(80, 3));
        this.packPluginMenu.setText("Package as plugin");
        this.packPluginMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Editor.this.packPluginMenuActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.packPluginMenu);
        this.fileMenu.add(this.jMenu1);
        this.shareMenu.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        this.shareMenu.setText("Share...");
        this.shareMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Editor.this.shareMenuActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.shareMenu);
        this.shareAsMenu.setAccelerator(KeyStroke.getKeyStroke(66, 3));
        this.shareAsMenu.setText("Share as...");
        this.shareAsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Editor.this.shareAsMenuActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.shareAsMenu);
        this.jMenuBar1.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.undoBtn.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.undoBtn.setText("Undo");
        this.undoBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Editor.this.undoBtnActionPerformed(evt);
            }
        });
        this.editMenu.add(this.undoBtn);
        this.redoBtn.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.redoBtn.setText("Redo");
        this.redoBtn.setToolTipText("");
        this.redoBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Editor.this.redoBtnActionPerformed(evt);
            }
        });
        this.editMenu.add(this.redoBtn);
        this.editMenu.add(this.jSeparator1);
        this.cutBtn.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.cutBtn.setText("Cut");
        this.cutBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Editor.this.cutBtnActionPerformed(evt);
            }
        });
        this.editMenu.add(this.cutBtn);
        this.copyBtn.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.copyBtn.setText("Copy");
        this.copyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Editor.this.copyBtnActionPerformed(evt);
            }
        });
        this.editMenu.add(this.copyBtn);
        this.pasteBtn.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.pasteBtn.setText("Paste");
        this.pasteBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Editor.this.pasteBtnActionPerformed(evt);
            }
        });
        this.editMenu.add(this.pasteBtn);
        this.jMenuBar1.add(this.editMenu);
        this.runMenu.setText("Run");
        this.runCodeBtn.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.runCodeBtn.setText("Run code");
        this.runCodeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Editor.this.runCodeBtnActionPerformed(evt);
            }
        });
        this.runMenu.add(this.runCodeBtn);
        this.killButton.setText("Kill script");
        this.killButton.setEnabled(false);
        this.killButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Editor.this.killButtonActionPerformed(evt);
            }
        });
        this.runMenu.add(this.killButton);
        this.codeLangMenu.setText("Language");
        this.javascriptOption.setAccelerator(KeyStroke.getKeyStroke(74, 2));
        this.langBtnGroup.add(this.javascriptOption);
        this.javascriptOption.setSelected(true);
        this.javascriptOption.setText("Javascript");
        this.javascriptOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Editor.this.javascriptOptionActionPerformed(evt);
            }
        });
        this.codeLangMenu.add(this.javascriptOption);
        this.pythonOption.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.langBtnGroup.add(this.pythonOption);
        this.pythonOption.setText("Python");
        this.pythonOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Editor.this.pythonOptionActionPerformed(evt);
            }
        });
        this.codeLangMenu.add(this.pythonOption);
        this.langBtnGroup.add(this.javaOption);
        this.javaOption.setText("Java");
        this.javaOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Editor.this.javaOptionActionPerformed(evt);
            }
        });
        this.codeLangMenu.add(this.javaOption);
        this.runMenu.add(this.codeLangMenu);
        this.jMenuBar1.add(this.runMenu);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void openMenuActionPerformed(ActionEvent evt) {
        int r = this.fc.showOpenDialog(this);
        if (r == 0) {
            try {
                File f = this.fc.getSelectedFile();
                this.openString(FileUtils.readFile(f.getAbsolutePath()), f.getAbsolutePath(), true);
            }
            catch (IOException ex) {
                JOptionPane.showInternalMessageDialog(this, "Error:  Cannot load file: " + ex.getMessage());
            }
        }
        this.codeBox.setCaretPosition(0);
    }

    public void openFileFromName(String file) {
        try {
            Debug.println(file);
            File f = new File(file);
            this.openString(FileUtils.readFile(f.getAbsolutePath()), f.getAbsolutePath(), true);
        }
        catch (IOException ex) {
            JOptionPane.showInternalMessageDialog(Main.mainPane, "Error:  Cannot load file: " + ex.getMessage());
            Main.loadRecentFiles();
        }
    }

    private void openString(String data, String file, boolean saved) {
        this.codeBox.setText(data);
        this.isSaved = saved;
        this.fileChanged = false;
        this.setTitle(new File(file).getName());
        if (file.matches(".*\\.(js|mls|symt|syjs)")) {
            this.javascriptOption.setSelected(true);
            this.pythonOption.setSelected(false);
            this.javaOption.setSelected(false);
            this.codeBox.setSyntaxEditingStyle("text/javascript");
            this.pyac.uninstall();
            this.jsac.install((JTextComponent)this.codeBox);
        } else if (file.matches(".*\\.(syjava|java)")) {
            this.javascriptOption.setSelected(false);
            this.pythonOption.setSelected(false);
            this.javaOption.setSelected(true);
            this.codeBox.setSyntaxEditingStyle("text/java");
        } else if (file.matches(".*\\.(sypy|py)")) {
            this.javascriptOption.setSelected(false);
            this.pythonOption.setSelected(true);
            this.javaOption.setSelected(false);
            this.codeBox.setSyntaxEditingStyle("text/python");
            this.jsac.uninstall();
            this.pyac.install((JTextComponent)this.codeBox);
        }
        this.filedata = new File(file);
    }

    private void saveMenuActionPerformed(ActionEvent evt) {
        if (!this.isSaved) {
            int r = this.fc.showSaveDialog(this);
            if (r == 0) {
                try {
                    this.filedata = FileUtils.getFileWithExtension(this.fc);
                    FileUtils.saveFile(this.codeBox.getText(), this.filedata.getAbsolutePath(), true);
                    this.isSaved = true;
                    this.fileChanged = false;
                    this.setTitle(FileUtils.getFileWithExtension(this.fc).getName());
                }
                catch (IOException ex) {
                    JOptionPane.showInternalMessageDialog(this, "Error:  Cannot save file: " + ex.getMessage());
                }
            }
        } else {
            try {
                FileUtils.saveFile(this.codeBox.getText(), this.filedata.getAbsolutePath(), true);
                this.fileChanged = false;
            }
            catch (IOException ex) {
                JOptionPane.showInternalMessageDialog(this, "Error:  Cannot save file: " + ex.getMessage());
            }
        }
        try {
            Debug.println(this.filedata.toString());
            Debug.println(this.filedata.getAbsolutePath());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void saveAsMenuActionPerformed(ActionEvent evt) {
        this.isSaved = false;
        this.saveMenuActionPerformed(evt);
    }

    private void runCodeBtnActionPerformed(ActionEvent evt) {
        if (this.javascriptOption.isSelected()) {
            this.rt = new RunThread("javascript");
            this.rt.start();
        } else if (this.pythonOption.isSelected()) {
            this.rt = new RunThread("python");
            this.rt.start();
        } else if (this.javaOption.isSelected()) {
            this.rt = new RunThread("java");
            this.rt.start();
        }
    }

    private void setRunning(boolean isRunning) {
        final boolean running = isRunning;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (running) {
                    Editor.this.runMenu.setText("Running...");
                    Editor.this.codeBox.setEditable(false);
                    for (Component mu : Editor.this.jMenuBar1.getComponents()) {
                        mu.setEnabled(false);
                    }
                    Editor.this.runMenu.setEnabled(true);
                    Editor.this.runCodeBtn.setEnabled(false);
                    Editor.this.codeLangMenu.setEnabled(false);
                    Editor.this.killButton.setEnabled(true);
                } else {
                    Editor.this.runMenu.setText("Run");
                    Editor.this.codeBox.setEditable(true);
                    for (Component mu : Editor.this.jMenuBar1.getComponents()) {
                        mu.setEnabled(true);
                    }
                    Editor.this.runCodeBtn.setEnabled(true);
                    Editor.this.codeLangMenu.setEnabled(true);
                    Editor.this.killButton.setEnabled(false);
                }
            }
        });
    }

    private void execCode(String lang) {
        if (!this.checkRequiredVersion(this.codeBox.getText(), lang)) {
            return;
        }
        this.cr = new CodeRunner(lang);
        this.uo = new UpdateOutput(this.cr);
        String script = this.loadExternalScripts(this.codeBox.getText(), lang);
        Debug.println(lang);
        Debug.println(script);
        this.uo.start();
        this.cr.evalCode(script);
        this.uo.kill();
    }

    private boolean checkRequiredVersion(String script, String lang) {
        String line;
        String prefix = "//";
        if (lang.startsWith("p")) {
            prefix = "##";
        }
        if ((line = script.trim().split("\\n", 2)[0]).startsWith(prefix + "needs ")) {
            String versions = line.substring(8).trim();
            Debug.println(versions);
            String min = versions;
            String max = "999999999";
            if (versions.contains("-")) {
                min = versions.split("-")[0];
                max = versions.split("-")[1];
            }
            try {
                int minNum = Integer.parseInt(min);
                int maxNum = Integer.parseInt(max);
                if (!((double)minNum <= 24.0) || !((double)maxNum >= 24.0)) {
                    JOptionPane.showInternalMessageDialog(this, "This script cannot be run on this version of SyMAT.");
                    return false;
                }
                return true;
            }
            catch (Exception ex) {
                this.outputBox.append("Error: Bad version selection syntax: " + ex.getMessage() + "\n");
            }
        } else {
            return true;
        }
        return false;
    }

    private String loadExternalScripts(String script, String lang) {
        String[] lines = script.split("\n");
        String result = "";
        String pre = "//";
        if (lang.startsWith("p")) {
            pre = "##";
        }
        for (String line : lines) {
            if (line.startsWith(pre + "include ") && !line.trim().endsWith(pre + "include")) {
                String temp = line.split(" ", 2)[1];
                try {
                    line = this.loadExternalScripts(FileUtils.readFile(this.filedata.getParent() + "./" + temp), lang);
                }
                catch (IOException ex) {
                    this.outputBox.append("Error: Cannot read referenced script file: " + ex.getMessage() + "\n");
                }
            }
            result = result + line + "\n";
        }
        return result;
    }

    private void exportMenuActionPerformed(ActionEvent evt) {
        String lang = this.pythonOption.isSelected() ? "python" : (this.javaOption.isSelected() ? "java" : "js");
        Main.loadFrame(new CodeExport(this.codeBox.getText(), lang, this.outputBox.getText()));
    }

    private void javascriptOptionActionPerformed(ActionEvent evt) {
        this.codeBox.setSyntaxEditingStyle("text/javascript");
        this.pyac.uninstall();
        this.javaac.uninstall();
        this.jsac.install((JTextComponent)this.codeBox);
    }

    private void pythonOptionActionPerformed(ActionEvent evt) {
        this.codeBox.setSyntaxEditingStyle("text/python");
        this.jsac.uninstall();
        this.javaac.uninstall();
        this.pyac.install((JTextComponent)this.codeBox);
    }

    private void formMouseClicked(MouseEvent evt) {
        this.loadTheme();
    }

    private void outputBoxMouseClicked(MouseEvent evt) {
        this.formMouseClicked(evt);
    }

    private void sampleHelloWorldActionPerformed(ActionEvent evt) {
        this.openSample("helloworld");
    }

    private void sampleGraphActionPerformed(ActionEvent evt) {
        this.openSample("graph");
    }

    private void pasteBtnActionPerformed(ActionEvent evt) {
        this.codeBox.paste();
    }

    private void copyBtnActionPerformed(ActionEvent evt) {
        this.codeBox.copy();
    }

    private void cutBtnActionPerformed(ActionEvent evt) {
        this.codeBox.cut();
    }

    private void clearBtnActionPerformed(ActionEvent evt) {
        this.outputBox.setText("");
    }

    private void undoBtnActionPerformed(ActionEvent evt) {
        this.codeBox.undoLastAction();
    }

    private void redoBtnActionPerformed(ActionEvent evt) {
        this.codeBox.redoLastAction();
    }

    private void shareMenuActionPerformed(ActionEvent evt) {
        this.createShared("");
    }

    private void shareAsMenuActionPerformed(ActionEvent evt) {
        String id = JOptionPane.showInternalInputDialog(this, "Enter the pad ID to share to.  If the pad exists, it will be overwritten.", "Share", 3);
        if (id != null && !id.equals("")) {
            this.createShared(id);
        }
    }

    private void packPluginMenuActionPerformed(ActionEvent evt) {
        Main.loadFrame(new PackagePlugin(this.codeBox.getText(), this.javascriptOption.isSelected() ? 0 : (this.pythonOption.isSelected() ? 1 : 2)));
    }

    private void killButtonActionPerformed(ActionEvent evt) {
        this.uo.kill();
        this.rt.stop();
        this.setRunning(false);
        this.outputBox.append("\n=============\nScript killed\n=============\n");
    }

    private void javaOptionActionPerformed(ActionEvent evt) {
        this.codeBox.setSyntaxEditingStyle("text/java");
        this.pyac.uninstall();
        this.jsac.uninstall();
        this.javaac.install((JTextComponent)this.codeBox);
    }

    private void createShared(String id) {
        try {
            String padid = Pads.genPad(id, this.codeBox.getText());
            Pads.addPad(padid);
            Pads.loadPad(padid);
            JOptionPane.showInternalMessageDialog(this, new SharePad(padid), "Share Pad", -1);
        }
        catch (Exception ex) {
            Debug.stacktrace(ex);
            JOptionPane.showInternalMessageDialog(this, "Could not create new pad: " + ex.getMessage(), "Error", 0);
        }
    }

    private void openSample(String name) {
        String ext = "js";
        if (this.javaOption.isSelected()) {
            ext = "java.txt";
        } else if (this.pythonOption.isSelected()) {
            ext = "py";
        }
        String text = "";
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(Editor.class.getResourceAsStream("codesamples/" + name + "." + ext)));
            while ((line = reader.readLine()) != null) {
                text = text + line + "\n";
            }
        }
        catch (Exception e) {
            this.outputBox.setText("Error: Could not open embedded sample file.");
        }
        this.openString(text, name + "." + ext.replace(".txt", ""), false);
    }

    @Override
    public void doDefaultCloseAction() {
        if (!this.fileChanged) {
            this.dispose();
        } else {
            int p = JOptionPane.showInternalConfirmDialog(this, "Do you want to save the file before closing?", "Unsaved Changes", 0, 3);
            if (p == 1) {
                this.dispose();
            } else {
                this.saveMenuActionPerformed(null);
            }
        }
    }

    private class UpdateOutput
    extends Thread {
        private final CodeRunner cr;
        private boolean keepGoing = true;

        public void kill() {
            this.keepGoing = false;
            this.flush();
        }

        @Override
        public void run() {
            while (this.keepGoing) {
                try {
                    this.flush();
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }

        private void flush() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String d = UpdateOutput.this.cr.getBufferDump();
                    if (!d.equals("")) {
                        Editor.this.outputBox.append(d);
                        Debug.println(d);
                    }
                }
            });
        }

        public UpdateOutput(CodeRunner c) {
            this.cr = c;
        }
    }

    private class RunThread
    extends Thread {
        String lang = "";

        public RunThread(String codelang) {
            this.lang = codelang;
        }

        @Override
        public void run() {
            if (Editor.this.filedata == null && Editor.this.codeBox.getText().contains("//include ")) {
                JOptionPane.showInternalMessageDialog(Main.mainPane, "You must save this file before using file includes!", "Save Required", 2);
                return;
            }
            Editor.this.setRunning(true);
            Editor.this.execCode(this.lang);
            Editor.this.setRunning(false);
        }
    }
}

