/*
 * Decompiled with CFR 0.152.
 */
package net.apocalypselabs.symat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.JOptionPane;
import net.apocalypselabs.symat.Debug;

public class CodeRunner {
    private ScriptEngine se;
    private StringWriter sw = new StringWriter();
    private PrintWriter pw = new PrintWriter(this.sw);
    private String modules = "";
    private String moduleterm = "";
    private boolean wrapRequired = false;
    private String scriptLang = "";

    public CodeRunner() {
        this("javascript");
    }

    public CodeRunner(int lang) {
        this(lang == 0 ? "js" : (lang == 2 ? "ja" : "py"));
    }

    public CodeRunner(String lang) {
        this.scriptLang = lang;
        switch (lang) {
            case "javascript": 
            case "js": 
            case "rhino": {
                this.scriptLang = "javascript";
                this.se = new ScriptEngineManager().getEngineByName("rhino");
                this.wrapRequired = true;
                try {
                    this.se.eval("importClass(net.apocalypselabs.symat.Functions);SyMAT_Functions = new net.apocalypselabs.symat.Functions();SyMAT_Functions.setLang('js');\n" + this.getFunctions("js") + this.loadToolkits());
                    this.se.put("engine", this.se);
                    this.attachWriters();
                }
                catch (Exception ex) {
                    this.initError(ex);
                }
                break;
            }
            case "python": 
            case "jython": 
            case "py": {
                this.scriptLang = "python";
                this.se = new ScriptEngineManager().getEngineByName("python");
                try {
                    this.se.eval("from math import *\nfrom net.apocalypselabs.symat import Functions\n_=Functions()\n_.setLang('py')\n\n" + this.getFunctions("py") + this.loadToolkits());
                    this.se.put("engine", this.se);
                    this.attachWriters();
                }
                catch (Exception ex) {
                    this.initError(ex);
                }
                break;
            }
            case "java": 
            case "ja": 
            case "beanshell": 
            case "bsh": {
                this.scriptLang = "java";
                this.se = new ScriptEngineManager().getEngineByName("java");
                try {
                    this.se.eval("import net.apocalypselabs.symat.Functions;Functions SyMAT_Functions = new Functions();SyMAT_Functions.setLang(\"java\");\n" + this.getFunctions("java") + this.loadToolkits());
                    this.se.put("engine", this.se);
                    this.attachWriters();
                }
                catch (Exception ex) {
                    this.initError(ex);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Script language " + lang + " not supported.");
            }
        }
    }

    public static List<InputStream> loadResources(String name, ClassLoader classLoader) throws IOException {
        ArrayList<InputStream> list = new ArrayList<InputStream>();
        Enumeration<URL> systemResources = (classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader).getResources(name);
        while (systemResources.hasMoreElements()) {
            list.add(systemResources.nextElement().openStream());
        }
        return list;
    }

    private String loadToolkits() {
        String out = "";
        try {
            List<InputStream> il = CodeRunner.loadResources("meta.txt", null);
            InputStream[] ii = new InputStream[il.size()];
            for (InputStream i : il.toArray(ii)) {
                BufferedReader br = new BufferedReader(new InputStreamReader(i));
                while (br.ready()) {
                    String l = br.readLine();
                    if (!l.contains("=")) continue;
                    String classname = l.split("=")[0];
                    String varname = l.split("=")[1];
                    if (this.scriptLang.equals("javascript")) {
                        out = out + "importClass(" + classname + ");" + varname + " = new " + classname + "();";
                        continue;
                    }
                    out = out + "from " + classname.substring(0, classname.lastIndexOf(".")) + " import " + classname.substring(classname.lastIndexOf(".") + 1) + "\n" + varname + " = " + classname.substring(classname.lastIndexOf(".") + 1) + "()\n";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Debug.println(out);
        return out;
    }

    @Deprecated
    public CodeRunner(String lang, boolean shell) {
        this(lang);
    }

    private void attachWriters() {
        this.se.getContext().setWriter(this.pw);
        this.se.getContext().setErrorWriter(this.pw);
        Debug.println("Attached writers.");
    }

    public CodeRunner(boolean fakeInit) {
        if (fakeInit) {
            this.se = new ScriptEngineManager().getEngineByName("python");
        }
    }

    public StringWriter getStringWriter() {
        return this.sw;
    }

    public PrintWriter getPrintWriter() {
        return this.pw;
    }

    public String getBufferDump() {
        String dump = this.sw.toString();
        this.sw.getBuffer().setLength(0);
        return dump;
    }

    private void initError(Exception ex) {
        JOptionPane.showMessageDialog(null, "Error: Could not properly initialize " + this.scriptLang + " scripting engine." + "\n\nSome functions may not work.\n\n" + "(" + ex.getMessage() + ")");
    }

    public Object evalString(String eval) {
        try {
            Object res = this.se.eval(this.wrapMath(eval));
            if (res == null) {
                res = "";
            }
            String result = res + this.sw.getBuffer().toString().trim();
            this.sw.getBuffer().setLength(0);
            return result;
        }
        catch (ScriptException ex) {
            return this.formatEx(ex);
        }
    }

    public void evalCode(String eval) {
        try {
            Object res = this.se.eval(this.wrapMath(eval));
            if (res == null) {
                res = "";
            }
        }
        catch (ScriptException ex) {
            this.sw.append(this.formatEx(ex));
        }
    }

    private String formatEx(ScriptException ex) {
        String err = ex.getMessage();
        return "Error: " + err;
    }

    private String wrapMath(String eval) {
        if (this.wrapRequired) {
            String with = "with(SyMAT_Functions){with(Math){" + eval + "}}";
            Debug.println(with);
            return with;
        }
        return eval;
    }

    public void setVar(String var, Object val) {
        this.se.put(var, val);
    }

    public Object getVar(String var) {
        return this.se.get(var);
    }

    private String getFunctions(String lang) {
        String text = "";
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(CodeRunner.class.getResourceAsStream("functions." + (lang.equals("java") ? "java.txt" : lang))));
            while ((line = reader.readLine()) != null) {
                text = text + line + "\n";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return text;
    }
}

