/*
 * Decompiled with CFR 0.152.
 */
package net.apocalypselabs.symat;

import com.itextpdf.text.DocListener;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.html.simpleparser.HTMLWorker;
import com.itextpdf.text.html.simpleparser.StyleSheet;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.apocalypselabs.symat.Debug;
import net.apocalypselabs.symat.FileUtils;
import net.apocalypselabs.symat.PrefStorage;
import net.apocalypselabs.symat.PrettifyToHtml;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.SimpleHtmlSerializer;
import org.htmlcleaner.TagNode;
import prettify.PrettifyParser;

public class CodeExport
extends JInternalFrame {
    private String codeLang = "js";
    private String html;
    private final String origCode;
    private String outputTxt = "";
    private JTextField authBox;
    private JTextField dateBox;
    private JButton exHtml;
    private JButton exPdf;
    private JTextArea headerBox;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JComboBox outputPlaceBox;
    private JTextPane previewPane;
    private JTextField titleBox;

    public CodeExport(final String code) {
        this.origCode = code;
        this.initComponents();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CodeExport.this.html = CodeExport.this.genHtml(code);
            }
        });
        this.html = this.genHtml(code);
        this.previewPane.setText(this.html);
        this.previewPane.setCaretPosition(0);
    }

    public CodeExport(String code, String lang) {
        this(code);
        this.codeLang = lang;
    }

    public CodeExport(String code, String lang, String out) {
        this(code, lang);
        this.outputTxt = out;
    }

    private String genHtml(String code) {
        String css = "";
        BufferedReader reader = new BufferedReader(new InputStreamReader(CodeExport.class.getResourceAsStream("pretty.css")));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                css = css + line;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(CodeExport.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.html = "<!DOCTYPE html><html><head><meta charset=\"utf-8\"><title></title><style type=\"text/css\"><!--" + css + "--></style>" + "</head>" + "<body>" + "<h1>" + this.titleBox.getText() + "</h1>";
        if (!this.authBox.getText().equals("")) {
            this.html = this.html + "<h2>Author: " + this.authBox.getText() + "</h2>";
        }
        if (!this.dateBox.getText().equals("")) {
            this.html = this.html + "<h3>Date: " + this.dateBox.getText() + "</h3>";
        }
        if (!this.headerBox.getText().equals("")) {
            this.html = this.html + "<p class=\"header\">" + this.headerBox.getText() + "</p>";
        }
        if (this.outputPlaceBox.getSelectedIndex() == 1) {
            this.html = this.html + this.getOutput();
        }
        PrettifyParser parser = new PrettifyParser();
        List parseResults = parser.parse(this.codeLang, code);
        this.html = this.html + PrettifyToHtml.toHtml(code, parseResults);
        if (this.outputPlaceBox.getSelectedIndex() == 0) {
            this.html = this.html + this.getOutput();
        }
        this.html = this.html + "</body></html>";
        this.html = this.html.replace("\t", "<span class=\"tab\">&nbsp;&nbsp;&nbsp;&nbsp;</span>");
        this.html = this.html.replace("\n", "<br>");
        HtmlCleaner cleaner = new HtmlCleaner();
        CleanerProperties props = cleaner.getProperties();
        TagNode node = cleaner.clean(this.html);
        this.html = new SimpleHtmlSerializer(props).getAsString(node);
        this.html = this.html.replace("&apos;", "'");
        this.html = this.html.replace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "");
        Debug.println(this.html);
        return this.html;
    }

    private String getOutput() {
        return "<p><b>Output:</b></p><pre class=\"plaintxt\">" + this.outputTxt.replace("<", "&lt;").replace("&", "&amp;").replace(">", "&gt;").replace("\"", "''") + "\n\n</pre>";
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.previewPane = new JTextPane();
        this.jPanel1 = new JPanel();
        this.titleBox = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.authBox = new JTextField();
        this.dateBox = new JTextField();
        this.jLabel3 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.headerBox = new JTextArea();
        this.jLabel4 = new JLabel();
        this.jButton1 = new JButton();
        this.jPanel2 = new JPanel();
        this.exHtml = new JButton();
        this.exPdf = new JButton();
        this.outputPlaceBox = new JComboBox();
        this.jLabel5 = new JLabel();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Export Code");
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/net/apocalypselabs/symat/icons/export.png")));
        this.previewPane.setEditable(false);
        this.previewPane.setContentType("text/html");
        this.jScrollPane1.setViewportView(this.previewPane);
        this.titleBox.setText("SyMAT Project");
        this.jLabel1.setText("Title:");
        this.jLabel2.setText("Author:");
        this.authBox.setText(PrefStorage.getSetting("author", ""));
        this.jLabel3.setText("Date:");
        this.headerBox.setColumns(20);
        this.headerBox.setLineWrap(true);
        this.headerBox.setRows(2);
        this.headerBox.setTabSize(4);
        this.headerBox.setWrapStyleWord(true);
        this.jScrollPane2.setViewportView(this.headerBox);
        this.jLabel4.setText("Header:");
        this.jButton1.setText("Update Preview");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeExport.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Export to:"));
        this.exHtml.setText("HTML");
        this.exHtml.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeExport.this.exHtmlActionPerformed(evt);
            }
        });
        this.exPdf.setText("PDF");
        this.exPdf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeExport.this.exPdfActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.exPdf, -1, -1, Short.MAX_VALUE).addComponent(this.exHtml, -1, 80, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.exHtml).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.exPdf).addContainerGap(-1, Short.MAX_VALUE)));
        this.outputPlaceBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Below code", "Above code", "No"}));
        this.outputPlaceBox.setSelectedIndex(2);
        this.jLabel5.setText("Include output:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.outputPlaceBox, 0, -1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.titleBox, -2, 154, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.authBox).addComponent(this.dateBox)))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton1)).addComponent(this.jScrollPane2, -1, 239, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(5, 5, 5).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.titleBox, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.jLabel4).addComponent(this.jButton1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jScrollPane2).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.authBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dateBox, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.outputPlaceBox, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE))).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addGap(0, 0, 0)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 583, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(0, 10, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 273, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.html = this.genHtml(this.origCode);
        this.previewPane.setText(this.html);
        this.previewPane.setCaretPosition(0);
    }

    private void exHtmlActionPerformed(ActionEvent evt) {
        this.doSave("html");
    }

    private void exPdfActionPerformed(ActionEvent evt) {
        this.doSave("pdf");
    }

    private void doSave(String format) {
        FileNameExtensionFilter filter;
        this.html = this.genHtml(this.origCode);
        JFileChooser fc = new JFileChooser();
        switch (format) {
            case "pdf": {
                filter = new FileNameExtensionFilter("Portable Document Format (PDF)", "pdf");
                break;
            }
            default: {
                filter = new FileNameExtensionFilter("Web Document (HTML)", "html");
            }
        }
        fc.setFileFilter(filter);
        fc.addChoosableFileFilter(filter);
        int r = fc.showSaveDialog(this);
        if (r == 0) {
            String file = FileUtils.getFileWithExtension(fc).getAbsolutePath();
            switch (format) {
                case "html": {
                    this.saveFile(this.html, file);
                    break;
                }
                case "pdf": {
                    this.savePdfFile(this.html, file);
                }
            }
        }
    }

    private void savePdfFile(String html, String path) {
        try {
            String k = html;
            try (FileOutputStream file = new FileOutputStream(new File(path));){
                Document document = new Document();
                PdfWriter.getInstance((Document)document, (OutputStream)file);
                document.open();
                HTMLWorker htmlWorker = new HTMLWorker((DocListener)document);
                StyleSheet styles = new StyleSheet();
                styles.loadStyle("com", "color", "green");
                styles.loadStyle("kwd", "color", "blue");
                styles.loadStyle("pln", "color", "black");
                styles.loadStyle("lit", "color", "#0099cc");
                styles.loadStyle("pun", "color", "black");
                styles.loadStyle("pun", "font-weight", "bold");
                htmlWorker.setStyleSheet(styles);
                htmlWorker.parse((Reader)new StringReader(k));
                document.close();
                this.savedMsg();
            }
        }
        catch (DocumentException | IOException e) {
            JOptionPane.showInternalMessageDialog(this, "Error saving: " + e.getMessage());
        }
    }

    private void saveFile(String content, String path) {
        try {
            PrintStream out = new PrintStream(new FileOutputStream(path));
            out.print(content);
            this.savedMsg();
        }
        catch (Exception ex) {
            JOptionPane.showInternalMessageDialog(this, "Error saving: " + ex.getMessage());
        }
    }

    private void savedMsg() {
        JOptionPane.showInternalMessageDialog(this, "Export complete!");
    }
}

