/*
 * Decompiled with CFR 0.152.
 */
package net.apocalypselabs.symat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import net.apocalypselabs.symat.Debug;
import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.DefaultCompletionProvider;
import org.fife.ui.autocomplete.VariableCompletion;

public class CodeCompleter {
    private final CompletionProvider provider;
    private final String lang;

    public CodeCompleter(String language) {
        this.lang = language;
        this.provider = this.makeCompletions();
    }

    public CompletionProvider getProvider() {
        return this.provider;
    }

    private CompletionProvider makeCompletions() {
        DefaultCompletionProvider provider = new DefaultCompletionProvider();
        try {
            String[] files;
            for (String fileid : files = new String[]{"functions", "constants"}) {
                String line;
                BufferedReader reader = this.lang.equals("java") ? new BufferedReader(new InputStreamReader(CodeCompleter.class.getResourceAsStream("resources/" + (fileid.equals(files[0]) ? "" : this.lang) + fileid + (fileid.equals(files[0]) ? "_java" : "") + ".txt"))) : new BufferedReader(new InputStreamReader(CodeCompleter.class.getResourceAsStream("resources/" + (fileid.equals(files[0]) ? "" : this.lang) + fileid + ".txt")));
                while ((line = reader.readLine()) != null) {
                    switch (fileid) {
                        case "functions": {
                            String[] args = line.split("\\|");
                            if (args.length == 2) {
                                provider.addCompletion(new BasicCompletion(provider, args[0], args[1]));
                                break;
                            }
                            if (args.length == 3) {
                                provider.addCompletion(new BasicCompletion(provider, args[0], args[1], args[2]));
                                break;
                            }
                            provider.addCompletion(new BasicCompletion((CompletionProvider)provider, args[0]));
                            break;
                        }
                        case "constants": {
                            provider.addCompletion(new VariableCompletion(provider, line, "double"));
                        }
                    }
                }
            }
        }
        catch (IOException ex) {
            Debug.printerr(ex.getMessage());
        }
        return provider;
    }
}

