/*
 * Decompiled with CFR 0.152.
 */
package org.jb2011.lnf.beautyeye.winlnfutils;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import org.jb2011.lnf.beautyeye.utils.MySwingUtilities2;

public class WinUtils {
    private static boolean isMnemonicHidden = true;

    public static boolean isMnemonicHidden() {
        if (UIManager.getBoolean("Button.showMnemonics")) {
            isMnemonicHidden = false;
        }
        return isMnemonicHidden;
    }

    public static boolean isOnVista() {
        boolean rv = false;
        String osName = System.getProperty("os.name");
        String osVers = System.getProperty("os.version");
        if (osName != null && osName.startsWith("Windows") && osVers != null && osVers.length() > 0) {
            int p = osVers.indexOf(46);
            if (p >= 0) {
                osVers = osVers.substring(0, p);
            }
            try {
                rv = Integer.parseInt(osVers) >= 6;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return rv;
    }

    public static void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text, int textShiftOffset) {
        FontMetrics fm = MySwingUtilities2.getFontMetrics(b, g);
        int mnemIndex = b.getDisplayedMnemonicIndex();
        if (WinUtils.isMnemonicHidden()) {
            mnemIndex = -1;
        }
        WinUtils.paintClassicText(b, g, textRect.x + textShiftOffset, textRect.y + fm.getAscent() + textShiftOffset, text, mnemIndex);
    }

    static void paintClassicText(AbstractButton b, Graphics g, int x, int y, String text, int mnemIndex) {
        ButtonModel model = b.getModel();
        Color color = b.getForeground();
        if (model.isEnabled()) {
            if (!(b instanceof JMenuItem && model.isArmed() || b instanceof JMenu && (model.isSelected() || model.isRollover()))) {
                g.setColor(b.getForeground());
            }
            MySwingUtilities2.drawStringUnderlineCharAt(b, g, text, mnemIndex, x, y);
        } else {
            color = UIManager.getColor("Button.shadow");
            Color shadow = UIManager.getColor("Button.disabledShadow");
            if (model.isArmed()) {
                color = UIManager.getColor("Button.disabledForeground");
            } else {
                if (shadow == null) {
                    shadow = b.getBackground().darker();
                }
                g.setColor(shadow);
                MySwingUtilities2.drawStringUnderlineCharAt(b, g, text, mnemIndex, x + 1, y + 1);
            }
            if (color == null) {
                color = b.getBackground().brighter();
            }
            g.setColor(color);
            MySwingUtilities2.drawStringUnderlineCharAt(b, g, text, mnemIndex, x, y);
        }
    }

    public static boolean isLeftToRight(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }
}

