/*
 * Decompiled with CFR 0.152.
 */
package org.jb2011.lnf.beautyeye.utils;

import java.awt.Color;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import org.jb2011.lnf.beautyeye.BeautyEyeLNFHelper;
import org.jb2011.lnf.beautyeye.utils.JVM;
import org.jb2011.lnf.beautyeye.utils.LogHelper;
import org.jb2011.lnf.beautyeye.utils.ReflectHelper;

public class WindowTranslucencyHelper {
    private static final String UN_WINDOWS_SORRY = "I'm sorry, the Linux platform does not support transparency, please pay attention to the next version of BeautyEye.";

    public static boolean isTranslucencySupported() {
        boolean isTranslucencySupported = false;
        try {
            if (JVM.current().isOrLater(30)) {
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice gd = ge.getDefaultScreenDevice();
                Class<?> _WindowTranslucency = Class.forName("java.awt.GraphicsDevice$WindowTranslucency");
                isTranslucencySupported = (Boolean)ReflectHelper.invokeMethod(GraphicsDevice.class, (Object)gd, "isWindowTranslucencySupported", new Class[]{_WindowTranslucency}, new Object[]{Enum.valueOf(_WindowTranslucency, "TRANSLUCENT")});
            } else if (JVM.current().isOrLater(16)) {
                Class<?> _WindowTranslucency = Class.forName("com.sun.awt.AWTUtilities$Translucency");
                isTranslucencySupported = (Boolean)ReflectHelper.invokeMethod(Class.forName("com.sun.awt.AWTUtilities"), _WindowTranslucency, "isTranslucencySupported", new Class[]{_WindowTranslucency}, new Object[]{Enum.valueOf(_WindowTranslucency, "TRANSLUCENT")});
            }
        }
        catch (Exception e) {
            if (BeautyEyeLNFHelper.debug) {
                e.printStackTrace();
            }
            LogHelper.debug("Exception at WindowTranslucencyHelper.isTranslucencySupported()," + e.getMessage());
        }
        return isTranslucencySupported;
    }

    public static void setOpacity(Window w, float opacity) {
        try {
            if (JVM.current().isOneDotSixUpdate12OrAfter()) {
                if (!WindowTranslucencyHelper.isTranslucencySupported()) {
                    LogHelper.debug("Your OS can't supported translucency.");
                    return;
                }
                if (JVM.current().isOrLater(30)) {
                    ReflectHelper.invokeMethod(Window.class, (Object)w, "setOpacity", new Class[]{Float.TYPE}, new Object[]{Float.valueOf(opacity)});
                } else {
                    ReflectHelper.invokeStaticMethod("com.sun.awt.AWTUtilities", "setWindowOpacity", new Class[]{Window.class, Float.TYPE}, new Object[]{w, Float.valueOf(opacity)});
                }
            } else {
                LogHelper.debug("\u60a8\u7684JRE\u7248\u672c\u4e0d\u652f\u6301\u6bcf\u50cf\u7d20\u534a\u900f\u660e(\u9700jre1.6_u12\u53ca\u4ee5\u4e0a\u7248\u672c)\uff0cBeautyEye\u5916\u89c2\u5c06\u4e0d\u80fd\u8fbe\u5230\u6700\u4f73\u89c6\u89c9\u6548\u679c\u54e6.");
            }
        }
        catch (Exception e) {
            if (BeautyEyeLNFHelper.debug) {
                e.printStackTrace();
            }
            LogHelper.debug("\u60a8\u7684JRE\u7248\u672c\u4e0d\u652f\u6301\u6bcf\u50cf\u7d20\u534a\u900f\u660e(\u9700jre1.6_u12\u53ca\u4ee5\u4e0a\u7248\u672c)\uff0cBeautyEye\u5916\u89c2\u5c06\u4e0d\u80fd\u8fbe\u5230\u6700\u4f73\u89c6\u89c9\u6548\u679c\u54e6." + e.getMessage());
        }
    }

    public static void setWindowOpaque(Window w, boolean opaque) {
        try {
            if (JVM.current().isOneDotSixUpdate12OrAfter()) {
                if (!WindowTranslucencyHelper.isTranslucencySupported()) {
                    LogHelper.debug("Your OS can't supported translucency.");
                    return;
                }
                if (JVM.current().isOrLater(30)) {
                    Color bgc = w.getBackground();
                    if (bgc == null) {
                        bgc = Color.black;
                    }
                    Color newBgn = new Color(bgc.getRed(), bgc.getGreen(), bgc.getBlue(), opaque ? 255 : 0);
                    w.setBackground(newBgn);
                } else {
                    ReflectHelper.invokeStaticMethod("com.sun.awt.AWTUtilities", "setWindowOpaque", new Class[]{Window.class, Boolean.TYPE}, new Object[]{w, opaque});
                }
            } else {
                LogHelper.debug("\u60a8\u7684JRE\u7248\u672c\u4e0d\u652f\u6301\u7a97\u53e3\u900f\u660e(\u9700jre1.6_u12\u53ca\u4ee5\u4e0a\u7248\u672c)\uff0cBeautyEye\u5916\u89c2\u5c06\u4e0d\u80fd\u8fbe\u5230\u6700\u4f73\u89c6\u89c9\u6548\u679c\u54e6.");
            }
        }
        catch (Exception e) {
            if (BeautyEyeLNFHelper.debug) {
                e.printStackTrace();
            }
            LogHelper.debug("\u60a8\u7684JRE\u7248\u672c\u4e0d\u652f\u6301\u7a97\u53e3\u900f\u660e(\u9700jre1.6_u12\u53ca\u4ee5\u4e0a\u7248\u672c)\uff0cBeautyEye\u5916\u89c2\u5c06\u4e0d\u80fd\u8fbe\u5230\u6700\u4f73\u89c6\u89c9\u6548\u679c\u54e6." + e.getMessage());
        }
    }
}

